/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.api.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProjectDto {
    private final String name;
    private Author creator;
    private String url;
    private String reposUrl;
    private String createdAt;

    public ProjectDto(String name) {
        this.name = Objects.requireNonNull(name, "name");
    }

    public ProjectDto(String name, Author creator, long creationTimeMillis) {
        this.name = Objects.requireNonNull(name, "name");
        this.creator = Objects.requireNonNull(creator, "creator");
        this.createdAt = DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(creationTimeMillis));
        this.url = "/api/v1/projects/" + name;
    }

    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Nullable
    @JsonProperty(value="creator")
    public Author creator() {
        return this.creator;
    }

    @Nullable
    @JsonProperty(value="url")
    public String url() {
        return this.url;
    }

    @Nullable
    @JsonProperty(value="reposUrl")
    public String reposUrl() {
        return this.reposUrl;
    }

    @Nullable
    @JsonProperty(value="createdAt")
    public String createdAt() {
        return this.createdAt;
    }

    public String toString() {
        MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper(this).add("name", this.name());
        if (this.creator() != null) {
            stringHelper.add("creator", this.creator());
        }
        if (this.createdAt() != null) {
            stringHelper.add("createdAt", this.createdAt());
        }
        return stringHelper.toString();
    }
}

