/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.api.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class PushResultDto {
    private final Revision revision;
    private final String pushedAt;

    public PushResultDto(Revision revision, long commitTimeMillis) {
        this.revision = Objects.requireNonNull(revision, "revision");
        this.pushedAt = DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(commitTimeMillis));
    }

    @JsonProperty(value="revision")
    public Revision revision() {
        return this.revision;
    }

    @JsonProperty(value="pushedAt")
    public String pushedAt() {
        return this.pushedAt;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("revision", this.revision()).add("pushedAt", this.pushedAt()).toString();
    }
}

