/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.api.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RepositoryDto {
    private final String name;
    private Author creator;
    private Revision headRevision;
    private String url;
    private String commitsUrl;
    private String compareUrl;
    private String contentsUrl;
    private String createdAt;

    public RepositoryDto(String name) {
        this.name = Objects.requireNonNull(name, "name");
    }

    public RepositoryDto(String projectName, String repoName, Author creator, Revision headRevision, long creationTimeMillis) {
        this.name = Objects.requireNonNull(repoName, "repoName");
        this.creator = Objects.requireNonNull(creator, "creator");
        this.headRevision = Objects.requireNonNull(headRevision, "headRevision");
        this.url = "/api/v1/projects/" + Objects.requireNonNull(projectName, "projectName") + "/repos" + '/' + repoName;
        this.createdAt = DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(creationTimeMillis));
    }

    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Nullable
    @JsonProperty(value="creator")
    public Author creator() {
        return this.creator;
    }

    @Nullable
    @JsonProperty(value="headRevision")
    public Revision headRevision() {
        return this.headRevision;
    }

    @Nullable
    @JsonProperty(value="url")
    public String url() {
        return this.url;
    }

    @Nullable
    @JsonProperty(value="commitsUrl")
    public String commitsUrl() {
        return this.commitsUrl;
    }

    @Nullable
    @JsonProperty(value="compareUrl")
    public String compareUrl() {
        return this.compareUrl;
    }

    @Nullable
    @JsonProperty(value="contentsUrl")
    public String contentsUrl() {
        return this.contentsUrl;
    }

    @Nullable
    @JsonProperty(value="createdAt")
    public String createdAt() {
        return this.createdAt;
    }

    public String toString() {
        MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper(this).add("name", this.name());
        if (this.creator() != null) {
            stringHelper.add("creator", this.creator());
        }
        if (this.headRevision() != null) {
            stringHelper.add("headRevision", this.headRevision());
        }
        if (this.createdAt() != null) {
            stringHelper.add("createdAt", this.createdAt());
        }
        return stringHelper.toString();
    }
}

