/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.api.v1;

import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import java.util.concurrent.TimeUnit;

public final class WatchTimeout {
    public static final long MAX_MILLIS = TimeUnit.DAYS.toMillis(1L);

    public static long availableTimeout(long expectedTimeoutMillis) {
        return WatchTimeout.availableTimeout(expectedTimeoutMillis, 0L);
    }

    public static long availableTimeout(long expectedTimeoutMillis, long currentTimeoutMillis) {
        Preconditions.checkArgument(expectedTimeoutMillis > 0L, "expectedTimeoutMillis: %s (expected: > 0)", expectedTimeoutMillis);
        Preconditions.checkArgument(currentTimeoutMillis >= 0L, "currentTimeoutMillis: %s (expected: >= 0)", currentTimeoutMillis);
        if (currentTimeoutMillis >= MAX_MILLIS) {
            return 0L;
        }
        long maxAvailableTimeoutMillis = MAX_MILLIS - currentTimeoutMillis;
        return Math.min(expectedTimeoutMillis, maxAvailableTimeoutMillis);
    }

    private WatchTimeout() {
    }
}

