/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatchException;
import com.linecorp.centraldogma.internal.jsonpatch.PathValueOperation;

public final class AddOperation
extends PathValueOperation {
    private static final String LAST_ARRAY_ELEMENT = "-";

    @JsonCreator
    public AddOperation(@JsonProperty(value="path") JsonPointer path, @JsonProperty(value="value") JsonNode value) {
        super("add", path, value);
    }

    @Override
    JsonNode apply(JsonNode node) {
        if (this.path.toString().isEmpty()) {
            return this.valueCopy();
        }
        JsonNode targetParent = AddOperation.ensureTargetParent(node, this.path);
        return targetParent.isArray() ? AddOperation.addToArray(this.path, node, this.valueCopy()) : AddOperation.addToObject(this.path, node, this.valueCopy());
    }

    static JsonNode addToArray(JsonPointer path, JsonNode node, JsonNode value) {
        int index;
        ArrayNode target = (ArrayNode)node.at(path.head());
        String rawToken = path.last().getMatchingProperty();
        if (rawToken.equals(LAST_ARRAY_ELEMENT)) {
            target.add(value);
            return node;
        }
        int size = target.size();
        try {
            index = Integer.parseInt(rawToken);
        }
        catch (NumberFormatException ignored) {
            throw new JsonPatchException("not an index: " + rawToken + " (expected: a non-negative integer)");
        }
        if (index < 0 || index > size) {
            throw new JsonPatchException("index out of bounds: " + index + " (expected: >= 0 && <= " + size + ')');
        }
        target.insert(index, value);
        return node;
    }

    static JsonNode addToObject(JsonPointer path, JsonNode node, JsonNode value) {
        ObjectNode target = (ObjectNode)node.at(path.head());
        target.set(path.last().getMatchingProperty(), value);
        return node;
    }
}

