/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.centraldogma.internal.jsonpatch.AddOperation;
import com.linecorp.centraldogma.internal.jsonpatch.DualPathOperation;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatchException;

public final class CopyOperation
extends DualPathOperation {
    @JsonCreator
    CopyOperation(@JsonProperty(value="from") JsonPointer from, @JsonProperty(value="path") JsonPointer path) {
        super("copy", from, path);
    }

    @Override
    JsonNode apply(JsonNode node) {
        JsonNode source = node.at(this.from);
        if (source.isMissingNode()) {
            throw new JsonPatchException("non-existent source path: " + this.from);
        }
        if (this.path.toString().isEmpty()) {
            return source;
        }
        JsonNode targetParent = CopyOperation.ensureTargetParent(node, this.path);
        source = source.deepCopy();
        return targetParent.isArray() ? AddOperation.addToArray(this.path, node, source) : AddOperation.addToObject(this.path, node, source);
    }
}

