/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.jsonpatch;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.centraldogma.internal.jsonpatch.AddOperation;
import com.linecorp.centraldogma.internal.jsonpatch.CopyOperation;
import com.linecorp.centraldogma.internal.jsonpatch.JsonNumEquals;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatch;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatchOperation;
import com.linecorp.centraldogma.internal.jsonpatch.RemoveOperation;
import com.linecorp.centraldogma.internal.jsonpatch.ReplaceMode;
import com.linecorp.centraldogma.internal.jsonpatch.ReplaceOperation;
import com.linecorp.centraldogma.internal.jsonpatch.SafeReplaceOperation;
import com.linecorp.centraldogma.internal.shaded.guava.base.Equivalence;
import com.linecorp.centraldogma.internal.shaded.guava.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class DiffProcessor {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();
    private final List<JsonPatchOperation> diffs = new ArrayList<JsonPatchOperation>();
    private final ReplaceMode replaceMode;
    private final Supplier<Map<JsonPointer, JsonNode>> unchangedValuesSupplier;

    DiffProcessor(ReplaceMode replaceMode, final Supplier<Map<JsonPointer, JsonNode>> unchangedValuesSupplier) {
        this.replaceMode = replaceMode;
        this.unchangedValuesSupplier = new Supplier<Map<JsonPointer, JsonNode>>(){
            @Nullable
            private Map<JsonPointer, JsonNode> unchangedValues;

            @Override
            public Map<JsonPointer, JsonNode> get() {
                if (this.unchangedValues == null) {
                    this.unchangedValues = (Map)unchangedValuesSupplier.get();
                }
                return this.unchangedValues;
            }
        };
    }

    void valueReplaced(JsonPointer pointer, JsonNode oldValue, JsonNode newValue) {
        switch (this.replaceMode) {
            case RFC6902: {
                this.diffs.add(new ReplaceOperation(pointer, newValue));
                break;
            }
            case SAFE: {
                this.diffs.add(new SafeReplaceOperation(pointer, oldValue, newValue));
            }
        }
    }

    void valueRemoved(JsonPointer pointer) {
        this.diffs.add(new RemoveOperation(pointer));
    }

    void valueAdded(JsonPointer pointer, JsonNode value) {
        JsonPointer ptr;
        JsonPatchOperation op = value.isContainerNode() ? ((ptr = this.findUnchangedValue(value)) != null ? new CopyOperation(ptr, pointer) : new AddOperation(pointer, value)) : new AddOperation(pointer, value);
        this.diffs.add(op);
    }

    JsonPatch getPatch() {
        return new JsonPatch(this.diffs);
    }

    @Nullable
    private JsonPointer findUnchangedValue(JsonNode value) {
        Map<JsonPointer, JsonNode> unchangedValues = this.unchangedValuesSupplier.get();
        if (unchangedValues.isEmpty()) {
            return null;
        }
        Predicate<JsonNode> predicate = EQUIVALENCE.equivalentTo(value);
        for (Map.Entry<JsonPointer, JsonNode> entry : unchangedValues.entrySet()) {
            if (!predicate.apply(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }
}

