/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.jsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.linecorp.centraldogma.internal.shaded.guava.base.Equivalence;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

final class JsonNumEquals
extends Equivalence<JsonNode> {
    private static final Equivalence<JsonNode> INSTANCE = new JsonNumEquals();

    public static Equivalence<JsonNode> getInstance() {
        return INSTANCE;
    }

    private JsonNumEquals() {
    }

    @Override
    protected boolean doEquivalent(JsonNode a, JsonNode b) {
        JsonNodeType typeB;
        if (a.isNumber() && b.isNumber()) {
            return JsonNumEquals.numEquals(a, b);
        }
        JsonNodeType typeA = a.getNodeType();
        if (typeA != (typeB = b.getNodeType())) {
            return false;
        }
        if (!a.isContainerNode()) {
            return a.equals((Object)b);
        }
        if (a.size() != b.size()) {
            return false;
        }
        return typeA == JsonNodeType.ARRAY ? this.arrayEquals(a, b) : this.objectEquals(a, b);
    }

    @Override
    protected int doHash(JsonNode t) {
        if (t.isNumber()) {
            return Double.valueOf(t.doubleValue()).hashCode();
        }
        if (!t.isContainerNode()) {
            return t.hashCode();
        }
        int ret = 0;
        if (t.size() == 0) {
            return ret;
        }
        if (t.isArray()) {
            for (JsonNode element : t) {
                ret = 31 * ret + this.doHash(element);
            }
            return ret;
        }
        Iterator iterator = t.fields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            ret = 31 * ret + (((String)entry.getKey()).hashCode() ^ this.doHash((JsonNode)entry.getValue()));
        }
        return ret;
    }

    private static boolean numEquals(JsonNode a, JsonNode b) {
        if (a.isIntegralNumber() && b.isIntegralNumber()) {
            return a.equals((Object)b);
        }
        return a.decimalValue().compareTo(b.decimalValue()) == 0;
    }

    private boolean arrayEquals(JsonNode a, JsonNode b) {
        int size = a.size();
        for (int i = 0; i < size; ++i) {
            if (this.doEquivalent(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean objectEquals(JsonNode a, JsonNode b) {
        HashSet<String> keys = Sets.newHashSet(a.fieldNames());
        HashSet set = Sets.newHashSet(b.fieldNames());
        if (!set.equals(keys)) {
            return false;
        }
        for (String key : keys) {
            if (this.doEquivalent(a.get(key), b.get(key))) continue;
            return false;
        }
        return true;
    }
}

