/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.jsonpatch.DiffProcessor;
import com.linecorp.centraldogma.internal.jsonpatch.JsonNumEquals;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatchException;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatchOperation;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatchUtil;
import com.linecorp.centraldogma.internal.jsonpatch.ReplaceMode;
import com.linecorp.centraldogma.internal.shaded.guava.base.Equivalence;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Iterators;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Sets;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;

public final class JsonPatch
implements JsonSerializable {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();
    private static final JsonPointer EMPTY_JSON_POINTER = JsonPointer.compile((String)"");
    private static final JsonPointer END_OF_ARRAY_POINTER = JsonPointer.compile((String)"/-");
    private final List<JsonPatchOperation> operations;

    public static JsonPatch fromJson(JsonNode node) throws IOException {
        Objects.requireNonNull(node, "node");
        try {
            return Jackson.treeToValue((TreeNode)node, JsonPatch.class);
        }
        catch (JsonMappingException e) {
            throw new JsonPatchException("invalid JSON patch", e);
        }
    }

    public static JsonPatch generate(JsonNode source, JsonNode target, ReplaceMode replaceMode) {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(target, "target");
        DiffProcessor processor = new DiffProcessor(replaceMode, () -> JsonPatch.unchangedValues(source, target));
        JsonPatch.generateDiffs(processor, EMPTY_JSON_POINTER, source, target);
        return processor.getPatch();
    }

    private static void generateDiffs(DiffProcessor processor, JsonPointer pointer, JsonNode source, JsonNode target) {
        JsonNodeType targetType;
        if (EQUIVALENCE.equivalent(source, target)) {
            return;
        }
        JsonNodeType sourceType = source.getNodeType();
        if (sourceType != (targetType = target.getNodeType())) {
            processor.valueReplaced(pointer, source, target);
            return;
        }
        if (!source.isContainerNode()) {
            processor.valueReplaced(pointer, source, target);
            return;
        }
        if (sourceType == JsonNodeType.OBJECT) {
            JsonPatch.generateObjectDiffs(processor, pointer, (ObjectNode)source, (ObjectNode)target);
        } else {
            JsonPatch.generateArrayDiffs(processor, pointer, (ArrayNode)source, (ArrayNode)target);
        }
    }

    private static void generateObjectDiffs(DiffProcessor processor, JsonPointer pointer, ObjectNode source, ObjectNode target) {
        TreeSet sourceFields = new TreeSet();
        Iterators.addAll(sourceFields, source.fieldNames());
        TreeSet targetFields = new TreeSet();
        Iterators.addAll(targetFields, target.fieldNames());
        for (String field : Sets.difference(sourceFields, targetFields)) {
            processor.valueRemoved(pointer.append(JsonPointer.valueOf((String)JsonPatchUtil.encodeSegment(field))));
        }
        for (String field : Sets.difference(targetFields, sourceFields)) {
            processor.valueAdded(pointer.append(JsonPointer.valueOf((String)JsonPatchUtil.encodeSegment(field))), target.get(field));
        }
        for (String field : Sets.intersection(sourceFields, targetFields)) {
            JsonPatch.generateDiffs(processor, pointer.append(JsonPointer.valueOf((String)JsonPatchUtil.encodeSegment(field))), source.get(field), target.get(field));
        }
    }

    private static void generateArrayDiffs(DiffProcessor processor, JsonPointer pointer, ArrayNode source, ArrayNode target) {
        int size;
        int index;
        int sourceSize = source.size();
        int targetSize = target.size();
        for (index = size = Math.min(sourceSize, targetSize); index < sourceSize; ++index) {
            processor.valueRemoved(pointer.append(JsonPointer.valueOf((String)("/" + size))));
        }
        for (index = 0; index < size; ++index) {
            JsonPatch.generateDiffs(processor, pointer.append(JsonPointer.valueOf((String)("/" + index))), source.get(index), target.get(index));
        }
        for (index = size; index < targetSize; ++index) {
            processor.valueAdded(pointer.append(END_OF_ARRAY_POINTER), target.get(index));
        }
    }

    static Map<JsonPointer, JsonNode> unchangedValues(JsonNode source, JsonNode target) {
        HashMap<JsonPointer, JsonNode> ret = new HashMap<JsonPointer, JsonNode>();
        JsonPatch.computeUnchanged(ret, EMPTY_JSON_POINTER, source, target);
        return ret;
    }

    private static void computeUnchanged(Map<JsonPointer, JsonNode> ret, JsonPointer pointer, JsonNode source, JsonNode target) {
        JsonNodeType targetType;
        if (EQUIVALENCE.equivalent(source, target)) {
            ret.put(pointer, target);
            return;
        }
        JsonNodeType sourceType = source.getNodeType();
        if (sourceType != (targetType = target.getNodeType())) {
            return;
        }
        switch (sourceType) {
            case OBJECT: {
                JsonPatch.computeUnchangedObject(ret, pointer, source, target);
                break;
            }
            case ARRAY: {
                JsonPatch.computeUnchangedArray(ret, pointer, source, target);
                break;
            }
        }
    }

    private static void computeUnchangedObject(Map<JsonPointer, JsonNode> ret, JsonPointer pointer, JsonNode source, JsonNode target) {
        Iterator sourceFields = source.fieldNames();
        while (sourceFields.hasNext()) {
            String name = (String)sourceFields.next();
            if (!target.has(name)) continue;
            JsonPatch.computeUnchanged(ret, pointer.append(JsonPointer.valueOf((String)JsonPatchUtil.encodeSegment(name))), source.get(name), target.get(name));
        }
    }

    private static void computeUnchangedArray(Map<JsonPointer, JsonNode> ret, JsonPointer pointer, JsonNode source, JsonNode target) {
        int size = Math.min(source.size(), target.size());
        for (int i = 0; i < size; ++i) {
            JsonPatch.computeUnchanged(ret, pointer.append(JsonPointer.valueOf((String)("/" + i))), source.get(i), target.get(i));
        }
    }

    @JsonCreator
    JsonPatch(List<JsonPatchOperation> operations) {
        this.operations = ImmutableList.copyOf(operations);
    }

    public boolean isEmpty() {
        return this.operations.isEmpty();
    }

    public List<JsonPatchOperation> operations() {
        return this.operations;
    }

    public JsonNode apply(JsonNode node) {
        Objects.requireNonNull(node, "node");
        JsonNode ret = node.deepCopy();
        for (JsonPatchOperation operation : this.operations) {
            ret = operation.apply(ret);
        }
        return ret;
    }

    public ArrayNode toJson() {
        return (ArrayNode)Jackson.valueToTree(this);
    }

    public String toString() {
        return this.operations.toString();
    }

    public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartArray();
        for (JsonPatchOperation op : this.operations) {
            op.serialize(jgen, provider);
        }
        jgen.writeEndArray();
    }

    public void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this.serialize(jgen, provider);
    }
}

