/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.jsonpatch;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.jsonpatch.AddOperation;
import com.linecorp.centraldogma.internal.jsonpatch.CopyOperation;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatchException;
import com.linecorp.centraldogma.internal.jsonpatch.MoveOperation;
import com.linecorp.centraldogma.internal.jsonpatch.RemoveIfExistsOperation;
import com.linecorp.centraldogma.internal.jsonpatch.RemoveOperation;
import com.linecorp.centraldogma.internal.jsonpatch.ReplaceOperation;
import com.linecorp.centraldogma.internal.jsonpatch.SafeReplaceOperation;
import com.linecorp.centraldogma.internal.jsonpatch.TestAbsenceOperation;
import com.linecorp.centraldogma.internal.jsonpatch.TestOperation;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="op")
@JsonSubTypes(value={@JsonSubTypes.Type(name="add", value=AddOperation.class), @JsonSubTypes.Type(name="copy", value=CopyOperation.class), @JsonSubTypes.Type(name="move", value=MoveOperation.class), @JsonSubTypes.Type(name="remove", value=RemoveOperation.class), @JsonSubTypes.Type(name="removeIfExists", value=RemoveIfExistsOperation.class), @JsonSubTypes.Type(name="replace", value=ReplaceOperation.class), @JsonSubTypes.Type(name="safeReplace", value=SafeReplaceOperation.class), @JsonSubTypes.Type(name="test", value=TestOperation.class), @JsonSubTypes.Type(name="testAbsence", value=TestAbsenceOperation.class)})
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class JsonPatchOperation
implements JsonSerializable {
    final String op;
    final JsonPointer path;

    public static JsonNode asJsonArray(JsonPatchOperation ... jsonPatchOperations) {
        Objects.requireNonNull(jsonPatchOperations, "jsonPatchOperations");
        return Jackson.valueToTree(jsonPatchOperations);
    }

    JsonPatchOperation(String op, JsonPointer path) {
        this.op = op;
        this.path = path;
    }

    public JsonPointer path() {
        return this.path;
    }

    abstract JsonNode apply(JsonNode var1);

    public abstract String toString();

    public JsonNode toJsonNode() {
        return JsonNodeFactory.instance.arrayNode().add(Jackson.valueToTree(this));
    }

    JsonNode ensureExistence(JsonNode node) {
        JsonNode found = node.at(this.path);
        if (found.isMissingNode()) {
            throw new JsonPatchException("non-existent path: " + this.path);
        }
        return found;
    }

    static JsonNode ensureSourceParent(JsonNode node, JsonPointer path) {
        return JsonPatchOperation.ensureParent(node, path, "source");
    }

    static JsonNode ensureTargetParent(JsonNode node, JsonPointer path) {
        return JsonPatchOperation.ensureParent(node, path, "target");
    }

    private static JsonNode ensureParent(JsonNode node, JsonPointer path, String typeName) {
        JsonPointer parentPath = path.head();
        JsonNode parentNode = node.at(parentPath);
        if (parentNode.isMissingNode()) {
            throw new JsonPatchException("non-existent " + typeName + " parent: " + parentPath);
        }
        if (!parentNode.isContainerNode()) {
            throw new JsonPatchException(typeName + " parent is not a container: " + parentPath + " (" + parentNode.getNodeType() + ')');
        }
        return parentNode;
    }
}

