/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.linecorp.centraldogma.internal.jsonpatch.AddOperation;
import com.linecorp.centraldogma.internal.jsonpatch.DualPathOperation;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatchException;

public final class MoveOperation
extends DualPathOperation {
    @JsonCreator
    MoveOperation(@JsonProperty(value="from") JsonPointer from, @JsonProperty(value="path") JsonPointer path) {
        super("move", from, path);
    }

    @Override
    JsonNode apply(JsonNode node) {
        if (this.from.equals((Object)this.path)) {
            return node;
        }
        if (node.at(this.from).isMissingNode()) {
            throw new JsonPatchException("non-existent source path: " + this.from);
        }
        JsonNode sourceParent = MoveOperation.ensureSourceParent(node, this.from);
        String raw = this.from.last().getMatchingProperty();
        JsonNode source = sourceParent.isObject() ? ((ObjectNode)sourceParent).remove(raw) : ((ArrayNode)sourceParent).remove(Integer.parseInt(raw));
        if (this.path.toString().isEmpty()) {
            return source;
        }
        JsonNode targetParent = MoveOperation.ensureTargetParent(node, this.path);
        return targetParent.isArray() ? AddOperation.addToArray(this.path, node, source) : AddOperation.addToObject(this.path, node, source);
    }
}

