/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.jsonpatch;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.linecorp.centraldogma.internal.jsonpatch.JsonNumEquals;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatchException;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatchOperation;
import com.linecorp.centraldogma.internal.shaded.guava.base.Equivalence;
import java.io.IOException;

abstract class PathValueOperation
extends JsonPatchOperation {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();
    @JsonSerialize
    private final JsonNode value;

    PathValueOperation(String op, JsonPointer path, JsonNode value) {
        super(op, path);
        this.value = value.deepCopy();
    }

    public JsonNode value() {
        return this.value;
    }

    JsonNode valueCopy() {
        return this.value.deepCopy();
    }

    void ensureEquivalence(JsonNode actual) {
        if (!EQUIVALENCE.equivalent(actual, this.value)) {
            throw new JsonPatchException("mismatching value at '" + this.path + "': " + actual + " (expected: " + this.value + ')');
        }
    }

    public final void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("op", this.op);
        jgen.writeStringField("path", this.path.toString());
        jgen.writeFieldName("value");
        jgen.writeTree((TreeNode)this.value);
        jgen.writeEndObject();
    }

    public final void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this.serialize(jgen, provider);
    }

    @Override
    public final String toString() {
        return "op: " + this.op + "; path: \"" + this.path + "\"; value: " + this.value;
    }
}

