/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatchOperation;
import java.io.IOException;

public final class RemoveIfExistsOperation
extends JsonPatchOperation {
    @JsonCreator
    public RemoveIfExistsOperation(@JsonProperty(value="path") JsonPointer path) {
        super("removeIfExists", path);
    }

    @Override
    JsonNode apply(JsonNode node) {
        if (this.path.toString().isEmpty()) {
            return MissingNode.getInstance();
        }
        JsonNode found = node.at(this.path);
        if (found.isMissingNode()) {
            return node;
        }
        JsonNode parentNode = node.at(this.path.head());
        String raw = this.path.last().getMatchingProperty();
        if (parentNode.isObject()) {
            ((ObjectNode)parentNode).remove(raw);
        } else if (parentNode.isArray()) {
            ((ArrayNode)parentNode).remove(Integer.parseInt(raw));
        }
        return node;
    }

    public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("op", "removeIfExists");
        jgen.writeStringField("path", this.path.toString());
        jgen.writeEndObject();
    }

    public void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this.serialize(jgen, provider);
    }

    @Override
    public String toString() {
        return "op: " + this.op + "; path: \"" + this.path + '\"';
    }
}

