/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.linecorp.centraldogma.internal.jsonpatch.JsonNumEquals;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatchException;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatchOperation;
import com.linecorp.centraldogma.internal.shaded.guava.base.Equivalence;
import java.io.IOException;

public final class SafeReplaceOperation
extends JsonPatchOperation {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();
    @JsonSerialize
    private final JsonNode oldValue;
    @JsonSerialize
    private final JsonNode newValue;

    @JsonCreator
    SafeReplaceOperation(@JsonProperty(value="path") JsonPointer path, @JsonProperty(value="oldValue") JsonNode oldValue, @JsonProperty(value="value") JsonNode newValue) {
        super("safeReplace", path);
        this.oldValue = oldValue.deepCopy();
        this.newValue = newValue.deepCopy();
    }

    @Override
    JsonNode apply(JsonNode node) {
        JsonNode actual = this.ensureExistence(node);
        if (!EQUIVALENCE.equivalent(actual, this.oldValue)) {
            throw new JsonPatchException("mismatching value at '" + this.path + "': " + actual + " (expected: " + this.oldValue + ')');
        }
        JsonNode replacement = this.newValue.deepCopy();
        if (this.path.toString().isEmpty()) {
            return replacement;
        }
        JsonNode parent = node.at(this.path.head());
        String rawToken = this.path.last().getMatchingProperty();
        if (parent.isObject()) {
            ((ObjectNode)parent).set(rawToken, replacement);
        } else {
            ((ArrayNode)parent).set(Integer.parseInt(rawToken), replacement);
        }
        return node;
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("op", this.op);
        gen.writeStringField("path", this.path.toString());
        gen.writeFieldName("oldValue");
        gen.writeTree((TreeNode)this.oldValue);
        gen.writeFieldName("value");
        gen.writeTree((TreeNode)this.newValue);
        gen.writeEndObject();
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    @Override
    public String toString() {
        return "op: " + this.op + "; path: \"" + this.path + "\"; oldValue: " + this.oldValue + "; value: " + this.newValue;
    }
}

