/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatchException;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatchOperation;
import java.io.IOException;

public final class TestAbsenceOperation
extends JsonPatchOperation {
    @JsonCreator
    public TestAbsenceOperation(@JsonProperty(value="path") JsonPointer path) {
        super("testAbsence", path);
    }

    @Override
    JsonNode apply(JsonNode node) {
        JsonNode found = node.at(this.path);
        if (!found.isMissingNode()) {
            throw new JsonPatchException("existent path: " + this.path);
        }
        return node;
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("op", this.op);
        gen.writeStringField("path", this.path.toString());
        gen.writeEndObject();
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    @Override
    public String toString() {
        return "op: " + this.op + "; path: \"" + this.path + '\"';
    }
}

