/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.cronutils;

import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.constraint.FieldConstraints;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.value.SpecialChar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringValidations {
    private static final SpecialChar[] SPECIAL_CHARS = new SpecialChar[]{SpecialChar.L, SpecialChar.LW, SpecialChar.W};
    private static final Pattern NUMS_AND_CHARS_PATTERN = Pattern.compile("[#\\?/\\*0-9]");
    private Pattern stringToIntKeysPattern;
    private Pattern lwPattern;

    public StringValidations(FieldConstraints constraints) {
        this.lwPattern = this.buildLWPattern(constraints.getSpecialChars());
        this.stringToIntKeysPattern = this.buildStringToIntPattern(constraints.getStringMappingKeySet());
    }

    Pattern buildStringToIntPattern(Set<String> strings) {
        return this.buildWordsPattern(strings);
    }

    public String removeValidChars(String exp) {
        Matcher numsAndCharsMatcher = NUMS_AND_CHARS_PATTERN.matcher(exp.toUpperCase());
        Matcher stringToIntKeysMatcher = this.stringToIntKeysPattern.matcher(numsAndCharsMatcher.replaceAll(""));
        Matcher specialWordsMatcher = this.lwPattern.matcher(stringToIntKeysMatcher.replaceAll(""));
        return specialWordsMatcher.replaceAll("").replaceAll("\\s+", "").replaceAll(",", "").replaceAll("-", "");
    }

    Pattern buildLWPattern(Set<SpecialChar> specialChars) {
        HashSet<String> scs = new HashSet<String>();
        for (SpecialChar sc : SPECIAL_CHARS) {
            if (!specialChars.contains((Object)sc)) continue;
            scs.add(sc.name());
        }
        return this.buildWordsPattern(scs);
    }

    Pattern buildWordsPattern(Set<String> words) {
        StringBuilder builder = new StringBuilder("\\b(");
        Iterator<String> iterator = words.iterator();
        if (!iterator.hasNext()) {
            builder.append(")\\b");
            return Pattern.compile(builder.toString());
        }
        String next = iterator.next();
        builder.append(next);
        while (iterator.hasNext()) {
            builder.append("|");
            builder.append(iterator.next());
        }
        builder.append(")\\b");
        return Pattern.compile(builder.toString());
    }
}

