/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.cronutils.descriptor;

import com.linecorp.centraldogma.internal.shaded.cronutils.descriptor.DescriptionStrategyFactory;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.Cron;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.CronField;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.CronFieldName;
import com.linecorp.centraldogma.internal.shaded.cronutils.utils.Preconditions;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class CronDescriptor {
    public static final Locale DEFAULT_LOCALE = Locale.UK;
    private ResourceBundle bundle = ResourceBundle.getBundle("CronUtilsI18N", DEFAULT_LOCALE);

    private CronDescriptor() {
    }

    public String describe(Cron cron) {
        Preconditions.checkNotNull(cron, "Cron must not be null");
        Map<CronFieldName, CronField> expressions = cron.retrieveFieldsAsMap();
        return (this.describeHHmmss(expressions) + " " + this.describeDayOfMonth(expressions) + " " + this.describeMonth(expressions) + " " + this.describeDayOfWeek(expressions) + " " + this.describeYear(expressions)).replaceAll("\\s+", " ").trim();
    }

    private String describeHHmmss(Map<CronFieldName, CronField> fields) {
        return DescriptionStrategyFactory.hhMMssInstance(this.bundle, fields.containsKey((Object)CronFieldName.HOUR) ? fields.get((Object)CronFieldName.HOUR).getExpression() : null, fields.containsKey((Object)CronFieldName.MINUTE) ? fields.get((Object)CronFieldName.MINUTE).getExpression() : null, fields.containsKey((Object)CronFieldName.SECOND) ? fields.get((Object)CronFieldName.SECOND).getExpression() : null).describe();
    }

    private String describeDayOfMonth(Map<CronFieldName, CronField> fields) {
        String description = DescriptionStrategyFactory.daysOfMonthInstance(this.bundle, fields.containsKey((Object)CronFieldName.DAY_OF_MONTH) ? fields.get((Object)CronFieldName.DAY_OF_MONTH).getExpression() : null).describe();
        return this.addTimeExpressions(description, this.bundle.getString("day"), this.bundle.getString("days"));
    }

    private String describeMonth(Map<CronFieldName, CronField> fields) {
        String description = DescriptionStrategyFactory.monthsInstance(this.bundle, fields.containsKey((Object)CronFieldName.MONTH) ? fields.get((Object)CronFieldName.MONTH).getExpression() : null).describe();
        return this.addTimeExpressions(description, this.bundle.getString("month"), this.bundle.getString("months"));
    }

    private String addTimeExpressions(String description, String singular, String plural) {
        return description.replaceAll("%s", singular).replaceAll("%p", plural);
    }

    private String describeDayOfWeek(Map<CronFieldName, CronField> fields) {
        String description = DescriptionStrategyFactory.daysOfWeekInstance(this.bundle, fields.containsKey((Object)CronFieldName.DAY_OF_WEEK) ? fields.get((Object)CronFieldName.DAY_OF_WEEK).getExpression() : null).describe();
        return this.addExpressions(description, this.bundle.getString("day"), this.bundle.getString("days"));
    }

    private String addExpressions(String description, String singular, String plural) {
        return description.replaceAll("%s", singular).replaceAll("%p", plural);
    }

    private String describeYear(Map<CronFieldName, CronField> fields) {
        return String.format(DescriptionStrategyFactory.plainInstance(this.bundle, fields.containsKey((Object)CronFieldName.YEAR) ? fields.get((Object)CronFieldName.YEAR).getExpression() : null).describe(), this.bundle.getString("year"));
    }

    public static CronDescriptor instance() {
        return new CronDescriptor();
    }
}

