/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.cronutils.model;

import com.linecorp.centraldogma.internal.shaded.cronutils.model.definition.CronConstraint;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.definition.CronDefinition;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.CronField;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.CronFieldName;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.expression.visitor.ValidationFieldExpressionVisitor;
import com.linecorp.centraldogma.internal.shaded.cronutils.utils.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Cron {
    private CronDefinition cronDefinition;
    private Map<CronFieldName, CronField> fields;
    private String asString;

    public Cron(CronDefinition cronDefinition, List<CronField> fields) {
        this.cronDefinition = Preconditions.checkNotNull(cronDefinition, "CronDefinition must not be null");
        Preconditions.checkNotNull(fields, "CronFields cannot be null");
        this.fields = new HashMap<CronFieldName, CronField>();
        for (CronField field : fields) {
            this.fields.put(field.getField(), field);
        }
    }

    public CronField retrieve(CronFieldName name) {
        return this.fields.get((Object)Preconditions.checkNotNull(name, "CronFieldName must not be null"));
    }

    public Map<CronFieldName, CronField> retrieveFieldsAsMap() {
        return Collections.unmodifiableMap(this.fields);
    }

    public String asString() {
        if (this.asString == null) {
            ArrayList<CronField> fields = new ArrayList<CronField>(this.fields.values());
            Collections.sort(fields, CronField.createFieldComparator());
            StringBuilder builder = new StringBuilder();
            for (int j = 0; j < fields.size(); ++j) {
                builder.append(String.format("%s ", fields.get(j).getExpression().asString()));
            }
            this.asString = builder.toString().trim();
        }
        return this.asString;
    }

    public CronDefinition getCronDefinition() {
        return this.cronDefinition;
    }

    public Cron validate() {
        for (Map.Entry<CronFieldName, CronField> field : this.retrieveFieldsAsMap().entrySet()) {
            CronFieldName fieldName = field.getKey();
            field.getValue().getExpression().accept(new ValidationFieldExpressionVisitor(this.getCronDefinition().getFieldDefinition(fieldName).getConstraints(), this.cronDefinition.isStrictRanges()));
        }
        for (CronConstraint constraint : this.getCronDefinition().getCronConstraints()) {
            if (constraint.validate(this)) continue;
            throw new IllegalArgumentException(String.format("Invalid cron expression: %s. %s", this.asString(), constraint.getDescription()));
        }
        return this;
    }

    public boolean equivalent(Cron cron) {
        return this.asString().equals(cron.asString());
    }
}

