/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.cronutils.model.definition;

import com.linecorp.centraldogma.internal.shaded.cronutils.model.definition.CronConstraint;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.CronFieldName;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.definition.FieldDefinition;
import com.linecorp.centraldogma.internal.shaded.cronutils.utils.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CronDefinition {
    private Map<CronFieldName, FieldDefinition> fieldDefinitions;
    private Set<CronConstraint> cronConstraints;
    private boolean lastFieldOptional;
    private boolean strictRanges;

    public CronDefinition(List<FieldDefinition> fieldDefinitions, Set<CronConstraint> cronConstraints, boolean lastFieldOptional, boolean strictRanges) {
        Preconditions.checkNotNull(fieldDefinitions, "Field definitions must not be null");
        Preconditions.checkNotNull(cronConstraints, "Cron validations must not be null");
        Preconditions.checkNotNullNorEmpty(fieldDefinitions, "Field definitions must not be empty");
        if (lastFieldOptional) {
            Preconditions.checkArgument(fieldDefinitions.size() > 1, "If last field is optional, field definition must hold at least two fields");
        }
        this.fieldDefinitions = new HashMap<CronFieldName, FieldDefinition>();
        for (FieldDefinition field : fieldDefinitions) {
            this.fieldDefinitions.put(field.getFieldName(), field);
        }
        this.cronConstraints = Collections.unmodifiableSet(cronConstraints);
        this.lastFieldOptional = lastFieldOptional;
        this.strictRanges = strictRanges;
    }

    public boolean isLastFieldOptional() {
        return this.lastFieldOptional;
    }

    public boolean isStrictRanges() {
        return this.strictRanges;
    }

    public Set<FieldDefinition> getFieldDefinitions() {
        return new HashSet<FieldDefinition>(this.fieldDefinitions.values());
    }

    public FieldDefinition getFieldDefinition(CronFieldName cronFieldName) {
        return this.fieldDefinitions.get((Object)cronFieldName);
    }

    public Set<CronConstraint> getCronConstraints() {
        return this.cronConstraints;
    }
}

