/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.cronutils.model.field.constraint;

import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.value.SpecialChar;
import com.linecorp.centraldogma.internal.shaded.cronutils.utils.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class FieldConstraints {
    private final Map<String, Integer> stringMapping;
    private final Map<Integer, Integer> intMapping;
    private final Set<SpecialChar> specialChars;
    private final Integer startRange;
    private final Integer endRange;

    public FieldConstraints(Map<String, Integer> stringMapping, Map<Integer, Integer> intMapping, Set<SpecialChar> specialChars, int startRange, int endRange) {
        this.stringMapping = Collections.unmodifiableMap(Preconditions.checkNotNull(stringMapping, "String mapping must not be null"));
        this.intMapping = Collections.unmodifiableMap(Preconditions.checkNotNull(intMapping, "Integer mapping must not be null"));
        this.specialChars = Collections.unmodifiableSet(Preconditions.checkNotNull(specialChars, "Special (non-standard) chars set must not be null"));
        this.startRange = startRange;
        this.endRange = endRange;
    }

    public int getStartRange() {
        return this.startRange;
    }

    public int getEndRange() {
        return this.endRange;
    }

    public Set<SpecialChar> getSpecialChars() {
        return this.specialChars;
    }

    public boolean isInRange(int value) {
        return value >= this.getStartRange() && value <= this.getEndRange();
    }

    public Set<String> getStringMappingKeySet() {
        return this.stringMapping.keySet();
    }

    public Integer getStringMappingValue(String exp) {
        return this.stringMapping.get(exp);
    }

    public Integer getIntMappingValue(Integer exp) {
        return this.intMapping.get(exp);
    }
}

