/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.cronutils.model.time;

import com.linecorp.centraldogma.internal.shaded.cronutils.mapper.WeekDay;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.Cron;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.definition.CronDefinition;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.CronField;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.CronFieldName;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.definition.DayOfWeekFieldDefinition;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.expression.Always;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.expression.QuestionMark;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.value.SpecialChar;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.time.ExecutionTimeBuilder;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.time.NearestValue;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.time.TimeNode;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.time.generator.FieldValueGenerator;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.time.generator.FieldValueGeneratorFactory;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.time.generator.NoSuchValueException;
import com.linecorp.centraldogma.internal.shaded.cronutils.utils.Preconditions;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionTime {
    private static final Logger log = LoggerFactory.getLogger(ExecutionTime.class);
    private CronDefinition cronDefinition;
    private FieldValueGenerator yearsValueGenerator;
    private CronField daysOfWeekCronField;
    private CronField daysOfMonthCronField;
    private TimeNode months;
    private TimeNode hours;
    private TimeNode minutes;
    private TimeNode seconds;

    ExecutionTime(CronDefinition cronDefinition, FieldValueGenerator yearsValueGenerator, CronField daysOfWeekCronField, CronField daysOfMonthCronField, TimeNode months, TimeNode hours, TimeNode minutes, TimeNode seconds) {
        this.cronDefinition = Preconditions.checkNotNull(cronDefinition);
        this.yearsValueGenerator = Preconditions.checkNotNull(yearsValueGenerator);
        this.daysOfWeekCronField = Preconditions.checkNotNull(daysOfWeekCronField);
        this.daysOfMonthCronField = Preconditions.checkNotNull(daysOfMonthCronField);
        this.months = Preconditions.checkNotNull(months);
        this.hours = Preconditions.checkNotNull(hours);
        this.minutes = Preconditions.checkNotNull(minutes);
        this.seconds = Preconditions.checkNotNull(seconds);
    }

    public static ExecutionTime forCron(Cron cron) {
        Map<CronFieldName, CronField> fields = cron.retrieveFieldsAsMap();
        ExecutionTimeBuilder executionTimeBuilder = new ExecutionTimeBuilder(cron.getCronDefinition());
        block9: for (CronFieldName name : CronFieldName.values()) {
            if (fields.get((Object)name) == null) continue;
            switch (name) {
                case SECOND: {
                    executionTimeBuilder.forSecondsMatching(fields.get((Object)name));
                    continue block9;
                }
                case MINUTE: {
                    executionTimeBuilder.forMinutesMatching(fields.get((Object)name));
                    continue block9;
                }
                case HOUR: {
                    executionTimeBuilder.forHoursMatching(fields.get((Object)name));
                    continue block9;
                }
                case DAY_OF_WEEK: {
                    executionTimeBuilder.forDaysOfWeekMatching(fields.get((Object)name));
                    continue block9;
                }
                case DAY_OF_MONTH: {
                    executionTimeBuilder.forDaysOfMonthMatching(fields.get((Object)name));
                    continue block9;
                }
                case MONTH: {
                    executionTimeBuilder.forMonthsMatching(fields.get((Object)name));
                    continue block9;
                }
                case YEAR: {
                    executionTimeBuilder.forYearsMatching(fields.get((Object)name));
                    continue block9;
                }
            }
        }
        return executionTimeBuilder.build();
    }

    public ZonedDateTime nextExecution(ZonedDateTime date) {
        Preconditions.checkNotNull(date);
        try {
            ZonedDateTime nextMatch = this.nextClosestMatch(date);
            if (nextMatch.equals(date)) {
                nextMatch = this.nextClosestMatch(date.plusSeconds(1L));
            }
            return nextMatch;
        }
        catch (NoSuchValueException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private ZonedDateTime nextClosestMatch(ZonedDateTime date) throws NoSuchValueException {
        List<Integer> year = this.yearsValueGenerator.generateCandidates(date.getYear(), date.getYear());
        TimeNode days = null;
        int lowestMonth = this.months.getValues().get(0);
        int lowestHour = this.hours.getValues().get(0);
        int lowestMinute = this.minutes.getValues().get(0);
        int lowestSecond = this.seconds.getValues().get(0);
        if (year.isEmpty()) {
            int newYear = this.yearsValueGenerator.generateNextValue(date.getYear());
            days = this.generateDays(this.cronDefinition, ZonedDateTime.of(LocalDateTime.of(newYear, lowestMonth, 1, 0, 0), date.getZone()));
            return this.initDateTime(this.yearsValueGenerator.generateNextValue(date.getYear()), lowestMonth, days.getValues().get(0), lowestHour, lowestMinute, lowestSecond, date.getZone());
        }
        if (!this.months.getValues().contains(date.getMonthValue())) {
            NearestValue nearestValue = this.months.getNextValue(date.getMonthValue(), 0);
            int nextMonths = nearestValue.getValue();
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), 1, 1, 0, 0, 0), date.getZone()).plusYears(nearestValue.getShifts());
                return this.nextClosestMatch(newDate);
            }
            if (nearestValue.getValue() < date.getMonthValue()) {
                date = date.plusYears(1L);
            }
            days = this.generateDays(this.cronDefinition, ZonedDateTime.of(LocalDateTime.of(date.getYear(), nextMonths, 1, 0, 0), date.getZone()));
            return this.initDateTime(date.getYear(), nextMonths, days.getValues().get(0), lowestHour, lowestMinute, lowestSecond, date.getZone());
        }
        days = this.generateDays(this.cronDefinition, date);
        if (!days.getValues().contains(date.getDayOfMonth())) {
            NearestValue nearestValue = days.getNextValue(date.getDayOfMonth(), 0);
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), date.getMonthValue(), 1, 0, 0, 0), date.getZone()).plusMonths(nearestValue.getShifts());
                return this.nextClosestMatch(newDate);
            }
            if (nearestValue.getValue() < date.getDayOfMonth()) {
                date = date.plusMonths(1L);
            }
            return this.initDateTime(date.getYear(), date.getMonthValue(), nearestValue.getValue(), lowestHour, lowestMinute, lowestSecond, date.getZone());
        }
        if (!this.hours.getValues().contains(date.getHour())) {
            NearestValue nearestValue = this.hours.getNextValue(date.getHour(), 0);
            int nextHours = nearestValue.getValue();
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), 0, 0, 0), date.getZone()).plusDays(nearestValue.getShifts());
                return this.nextClosestMatch(newDate);
            }
            if (nearestValue.getValue() < date.getHour()) {
                date = date.plusDays(1L);
            }
            return this.initDateTime(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), nextHours, lowestMinute, lowestSecond, date.getZone());
        }
        if (!this.minutes.getValues().contains(date.getMinute())) {
            NearestValue nearestValue = this.minutes.getNextValue(date.getMinute(), 0);
            int nextMinutes = nearestValue.getValue();
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), 0, 0), date.getZone()).plusHours(nearestValue.getShifts());
                return this.nextClosestMatch(newDate);
            }
            if (nearestValue.getValue() < date.getMinute()) {
                date = date.plusHours(1L);
            }
            return this.initDateTime(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), nextMinutes, lowestSecond, date.getZone());
        }
        if (!this.seconds.getValues().contains(date.getSecond())) {
            NearestValue nearestValue = this.seconds.getNextValue(date.getSecond(), 0);
            int nextSeconds = nearestValue.getValue();
            if (nearestValue.getShifts() > 0) {
                ZonedDateTime newDate = ZonedDateTime.of(LocalDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), date.getMinute(), 0), date.getZone()).plusMinutes(nearestValue.getShifts());
                return this.nextClosestMatch(newDate);
            }
            if (nearestValue.getValue() < date.getSecond()) {
                date = date.plusMinutes(1L);
            }
            return this.initDateTime(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), date.getHour(), date.getMinute(), nextSeconds, date.getZone());
        }
        return date;
    }

    private TimeNode generateDays(CronDefinition cronDefinition, ZonedDateTime date) {
        if (cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK) != null && cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_MONTH) != null) {
            return this.generateDaysDoWAndDoMSupported(cronDefinition, date);
        }
        if (cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK) == null) {
            return this.generateDayCandidatesUsingDoM(date);
        }
        return this.generateDayCandidatesUsingDoW(date, ((DayOfWeekFieldDefinition)cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue());
    }

    private TimeNode generateDaysDoWAndDoMSupported(CronDefinition cronDefinition, ZonedDateTime date) {
        boolean questionMarkSupported = cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK).getConstraints().getSpecialChars().contains((Object)SpecialChar.QUESTION_MARK);
        if (questionMarkSupported) {
            return new TimeNode(this.generateDayCandidatesQuestionMarkSupportedUsingDoWAndDoM(date.getYear(), date.getMonthValue(), ((DayOfWeekFieldDefinition)cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue()));
        }
        return new TimeNode(this.generateDayCandidatesQuestionMarkNotSupportedUsingDoWAndDoM(date.getYear(), date.getMonthValue(), ((DayOfWeekFieldDefinition)cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue()));
    }

    private List<Integer> generateDayCandidatesQuestionMarkNotSupportedUsingDoWAndDoM(int year, int month, WeekDay mondayDoWValue) {
        LocalDate date = LocalDate.of(year, month, 1);
        int lengthOfMonth = date.lengthOfMonth();
        HashSet<Integer> candidates = new HashSet<Integer>();
        if (this.daysOfMonthCronField.getExpression() instanceof Always && this.daysOfWeekCronField.getExpression() instanceof Always) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth));
        } else if (this.daysOfMonthCronField.getExpression() instanceof Always) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, year, month, mondayDoWValue).generateCandidates(1, lengthOfMonth));
        } else if (this.daysOfWeekCronField.getExpression() instanceof Always) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth));
        } else {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, year, month, mondayDoWValue).generateCandidates(1, lengthOfMonth));
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth));
        }
        ArrayList<Integer> candidatesList = new ArrayList<Integer>(candidates);
        Collections.sort(candidatesList);
        return candidatesList;
    }

    private List<Integer> generateDayCandidatesQuestionMarkSupportedUsingDoWAndDoM(int year, int month, WeekDay mondayDoWValue) {
        LocalDate date = LocalDate.of(year, month, 1);
        int lengthOfMonth = date.lengthOfMonth();
        HashSet<Integer> candidates = new HashSet<Integer>();
        if (this.daysOfMonthCronField.getExpression() instanceof Always && this.daysOfWeekCronField.getExpression() instanceof Always) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth));
        } else if (this.daysOfMonthCronField.getExpression() instanceof QuestionMark) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, year, month, mondayDoWValue).generateCandidates(1, lengthOfMonth));
        } else if (this.daysOfWeekCronField.getExpression() instanceof QuestionMark) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth));
        } else {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, year, month, mondayDoWValue).generateCandidates(1, lengthOfMonth));
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, lengthOfMonth));
        }
        ArrayList<Integer> candidatesList = new ArrayList<Integer>(candidates);
        Collections.sort(candidatesList);
        return candidatesList;
    }

    private TimeNode generateDayCandidatesUsingDoM(ZonedDateTime reference) {
        LocalDate date = LocalDate.of(reference.getYear(), reference.getMonthValue(), 1);
        int lengthOfMonth = date.lengthOfMonth();
        HashSet<Integer> candidates = new HashSet<Integer>(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, reference.getYear(), reference.getMonthValue()).generateCandidates(1, lengthOfMonth));
        ArrayList<Integer> candidatesList = new ArrayList<Integer>(candidates);
        Collections.sort(candidatesList);
        return new TimeNode(candidatesList);
    }

    private TimeNode generateDayCandidatesUsingDoW(ZonedDateTime reference, WeekDay mondayDoWValue) {
        LocalDate date = LocalDate.of(reference.getYear(), reference.getMonthValue(), 1);
        int lengthOfMonth = date.lengthOfMonth();
        HashSet<Integer> candidates = new HashSet<Integer>(FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, reference.getYear(), reference.getMonthValue(), mondayDoWValue).generateCandidates(0, lengthOfMonth + 1));
        ArrayList<Integer> candidatesList = new ArrayList<Integer>(candidates);
        Collections.sort(candidatesList);
        return new TimeNode(candidatesList);
    }

    private ZonedDateTime initDateTime(int years, int monthsOfYear, int dayOfMonth, int hoursOfDay, int minutesOfHour, int secondsOfMinute, ZoneId timeZone) {
        ZonedDateTime date = ZonedDateTime.of(LocalDateTime.of(0, 1, 1, 0, 0, 0), timeZone).plusYears(years).plusMonths(monthsOfYear - 1).plusDays(dayOfMonth - 1).plusHours(hoursOfDay).plusMinutes(minutesOfHour).plusSeconds(secondsOfMinute);
        return this.ensureSameDate(date, years, monthsOfYear, dayOfMonth, hoursOfDay, minutesOfHour, secondsOfMinute);
    }

    private ZonedDateTime ensureSameDate(ZonedDateTime date, int years, int monthsOfYear, int dayOfMonth, int hoursOfDay, int minutesOfHour, int secondsOfMinute) {
        if (date.getSecond() != secondsOfMinute) {
            date = date.plusSeconds(secondsOfMinute - date.getSecond());
        }
        if (date.getMinute() != minutesOfHour) {
            date = date.plusMinutes(minutesOfHour - date.getMinute());
        }
        if (date.getHour() != hoursOfDay) {
            date = date.plusHours(hoursOfDay - date.getHour());
        }
        if (date.getDayOfMonth() != dayOfMonth) {
            date = date.plusDays(dayOfMonth - date.getDayOfMonth());
        }
        if (date.getMonthValue() != monthsOfYear) {
            date = date.plusMonths(monthsOfYear - date.getMonthValue());
        }
        if (date.getYear() != years) {
            date = date.plusYears(years - date.getYear());
        }
        return date;
    }
}

