/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.cronutils.model.time;

import com.linecorp.centraldogma.internal.shaded.cronutils.model.time.NearestValue;
import com.linecorp.centraldogma.internal.shaded.cronutils.utils.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

class TimeNode {
    protected List<Integer> values;

    public TimeNode(List<Integer> values) {
        this.values = Preconditions.checkNotNullNorEmpty(values, "Values must not be empty");
        Collections.sort(this.values);
    }

    public NearestValue getNextValue(int reference, int shifts) {
        return this.getNearestForwardValue(reference, shifts);
    }

    public List<Integer> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    NearestValue getNearestForwardValue(int reference, int shiftsToApply) {
        ArrayList<Integer> values = new ArrayList<Integer>(this.values);
        int index = 0;
        boolean foundGreater = false;
        AtomicInteger shift = new AtomicInteger(0);
        if (!values.contains(reference)) {
            for (Integer value : values) {
                if (value <= reference) continue;
                index = values.indexOf(value);
                --shiftsToApply;
                foundGreater = true;
                break;
            }
            if (!foundGreater) {
                shift.incrementAndGet();
            }
        } else {
            index = values.indexOf(reference);
        }
        int value = (Integer)values.get(index);
        for (int j = 0; j < shiftsToApply; ++j) {
            value = this.getValueFromList(values, index + 1, shift);
            index = values.indexOf(value);
        }
        return new NearestValue(value, shift.get());
    }

    int getValueFromList(List<Integer> values, int index, AtomicInteger shift) {
        Preconditions.checkNotNullNorEmpty(values, "List must not be empty");
        if (index < 0) {
            shift.incrementAndGet();
            return this.getValueFromList(values, index += values.size(), shift);
        }
        if (index >= values.size()) {
            shift.incrementAndGet();
            return this.getValueFromList(values, index -= values.size(), shift);
        }
        return values.get(index);
    }
}

