/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.cronutils.parser;

import com.linecorp.centraldogma.internal.shaded.cronutils.StringValidations;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.constraint.FieldConstraints;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.expression.Always;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.expression.And;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.expression.Between;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.expression.Every;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.expression.FieldExpression;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.expression.On;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.expression.QuestionMark;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.value.FieldValue;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.value.IntegerFieldValue;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.value.SpecialChar;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.field.value.SpecialCharFieldValue;
import com.linecorp.centraldogma.internal.shaded.cronutils.utils.Preconditions;
import com.linecorp.centraldogma.internal.shaded.cronutils.utils.StringUtils;
import java.util.regex.Pattern;

public class FieldParser {
    private static final char[] SPECIAL_CHARS_MINUS_STAR = new char[]{'/', '-', ','};
    private static final Pattern L_PATTERN = Pattern.compile("[0-9]L", 2);
    private static final Pattern W_PATTERN = Pattern.compile("[0-9]W", 2);
    private FieldConstraints fieldConstraints;

    public FieldParser(FieldConstraints constraints) {
        this.fieldConstraints = Preconditions.checkNotNull(constraints, "FieldConstraints must not be null");
    }

    public FieldExpression parse(String expression) {
        if (!StringUtils.containsAny(expression, SPECIAL_CHARS_MINUS_STAR)) {
            return this.noSpecialCharsNorStar(expression);
        }
        String[] array = expression.split(",");
        if (array.length > 1) {
            return this.commaSplitResult(array);
        }
        String[] betWeenArray = expression.split("-");
        return this.dashSplitResult(expression, betWeenArray);
    }

    private FieldExpression dashSplitResult(String expression, String[] betWeenArray) {
        if (betWeenArray.length > 1) {
            return this.parseBetween(betWeenArray);
        }
        return this.slashSplit(expression, expression.split("/"));
    }

    private FieldExpression commaSplitResult(String[] array) {
        And and = new And();
        for (String exp : array) {
            and.and(this.parse(exp));
        }
        return and;
    }

    private FieldExpression slashSplit(String expression, String[] values) {
        if (values.length == 2) {
            String start = values[0];
            String value = values[1];
            return this.asteriskOrempty(start, value);
        }
        if (values.length == 1) {
            throw new IllegalArgumentException("Missing steps for expression: " + expression);
        }
        throw new IllegalArgumentException("Invalid expression: " + expression);
    }

    private FieldExpression asteriskOrempty(String start, String value) {
        String trimmedStart = start.trim();
        if ("*".equals(trimmedStart) || "".equals(start.trim())) {
            return new Every(new IntegerFieldValue(Integer.parseInt(value)));
        }
        return new Every(new On(new IntegerFieldValue(Integer.parseInt(start))), new IntegerFieldValue(Integer.parseInt(value)));
    }

    private FieldExpression noSpecialCharsNorStar(String expression) {
        if ("*".equals(expression)) {
            return new Always();
        }
        if ("?".equals(expression)) {
            return new QuestionMark();
        }
        return this.parseOn(expression);
    }

    protected FieldExpression parseBetween(String[] array) {
        if (array[0].isEmpty() || array[1].isEmpty()) {
            throw new IllegalArgumentException(String.format("Invalid expression! Expression: %s-%s does not describe a range. Negative numbers are not allowed.", array[0], array[1]));
        }
        if (array[1].contains("/")) {
            String[] every = array[1].split("/");
            return new Every(new Between(this.map(array[0]), this.map(every[0])), this.mapToIntegerFieldValue(every[1]));
        }
        return new Between(this.map(array[0]), this.map(array[1]));
    }

    protected On parseOn(String exp) {
        if ("?".equals(exp)) {
            return this.parseOnWithQuestionMark(exp);
        }
        if (exp.contains("#")) {
            return this.parseOnWithHash(exp);
        }
        if (exp.contains("LW")) {
            return this.parseOnWithLW(exp);
        }
        if (L_PATTERN.matcher(exp).find() || exp.equalsIgnoreCase("L")) {
            return this.parseOnWithL(exp);
        }
        if (W_PATTERN.matcher(exp).find()) {
            return this.parseOnWithW(exp);
        }
        return new On(this.mapToIntegerFieldValue(exp), new SpecialCharFieldValue(SpecialChar.NONE), new IntegerFieldValue(-1));
    }

    protected On parseOnWithHash(String exp) {
        SpecialCharFieldValue specialChar = new SpecialCharFieldValue(SpecialChar.HASH);
        String[] array = exp.split("#");
        IntegerFieldValue nth = this.mapToIntegerFieldValue(array[1]);
        if (array[0].isEmpty()) {
            throw new IllegalArgumentException("Time should be specified!");
        }
        return new On(this.mapToIntegerFieldValue(array[0]), specialChar, nth);
    }

    protected On parseOnWithQuestionMark(String exp) {
        SpecialCharFieldValue specialChar = new SpecialCharFieldValue(SpecialChar.QUESTION_MARK);
        String questionMarkExpression = exp.replace("?", "");
        if ("".equals(questionMarkExpression)) {
            return new On(new IntegerFieldValue(-1), specialChar, new IntegerFieldValue(-1));
        }
        throw new IllegalArgumentException(String.format("Expected: '?', found: %s", questionMarkExpression));
    }

    protected On parseOnWithLW(String exp) {
        SpecialCharFieldValue specialChar = new SpecialCharFieldValue(SpecialChar.LW);
        String lwExpression = exp.replace("LW", "");
        if ("".equals(lwExpression)) {
            return new On(new IntegerFieldValue(-1), specialChar, new IntegerFieldValue(-1));
        }
        throw new IllegalArgumentException(String.format("Expected: LW, found: %s", lwExpression));
    }

    protected On parseOnWithL(String exp) {
        SpecialCharFieldValue specialChar = new SpecialCharFieldValue(SpecialChar.L);
        String lExpression = exp.replace("L", "");
        IntegerFieldValue time = new IntegerFieldValue(-1);
        if (!"".equals(lExpression)) {
            time = this.mapToIntegerFieldValue(lExpression);
        }
        return new On(time, specialChar, new IntegerFieldValue(-1));
    }

    protected On parseOnWithW(String exp) {
        return new On(this.mapToIntegerFieldValue(exp.replace("W", "")), new SpecialCharFieldValue(SpecialChar.W), new IntegerFieldValue(-1));
    }

    protected IntegerFieldValue mapToIntegerFieldValue(String string) {
        try {
            return new IntegerFieldValue(this.intToInt(this.stringToInt(string)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Invalid value. Expected some integer, found %s", string));
        }
    }

    protected FieldValue<?> map(String string) {
        for (SpecialChar sc : SpecialChar.values()) {
            if (!sc.toString().equals(string)) continue;
            return new SpecialCharFieldValue(sc);
        }
        return new IntegerFieldValue(this.stringToInt(string));
    }

    protected int stringToInt(String exp) {
        Integer value = this.fieldConstraints.getStringMappingValue(exp);
        if (value != null) {
            return value;
        }
        try {
            return Integer.parseInt(exp);
        }
        catch (NumberFormatException e) {
            String invalidChars = new StringValidations(this.fieldConstraints).removeValidChars(exp);
            throw new IllegalArgumentException(String.format("Invalid chars in expression! Expression: %s Invalid chars: %s", exp, invalidChars));
        }
    }

    protected int intToInt(Integer exp) {
        Integer value = this.fieldConstraints.getIntMappingValue(exp);
        if (value != null) {
            return value;
        }
        return exp;
    }
}

