/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.guava.base;

import com.linecorp.centraldogma.internal.shaded.guava.base.PatternCompiler;
import java.util.Locale;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;

final class Platform {
    private static final Logger logger = Logger.getLogger(Platform.class.getName());
    private static final PatternCompiler patternCompiler = Platform.loadPatternCompiler();

    private Platform() {
    }

    static long systemNanoTime() {
        return System.nanoTime();
    }

    static String formatCompact4Digits(double value) {
        return String.format(Locale.ROOT, "%.4g", value);
    }

    static boolean stringIsNullOrEmpty(@CheckForNull String string) {
        return string == null || string.isEmpty();
    }

    static String nullToEmpty(@CheckForNull String string) {
        return string == null ? "" : string;
    }

    @CheckForNull
    static String emptyToNull(@CheckForNull String string) {
        return Platform.stringIsNullOrEmpty(string) ? null : string;
    }

    private static PatternCompiler loadPatternCompiler() {
        return new JdkPatternCompiler();
    }

    private static final class JdkPatternCompiler
    implements PatternCompiler {
        private JdkPatternCompiler() {
        }
    }
}

