/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.guava.collect;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.DoNotCall;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableCollection;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableSortedSetFauxverideShim;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Iterables;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Iterators;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Ordering;
import com.linecorp.centraldogma.internal.shaded.guava.collect.RegularImmutableSortedSet;
import com.linecorp.centraldogma.internal.shaded.guava.collect.SortedIterable;
import com.linecorp.centraldogma.internal.shaded.guava.collect.UnmodifiableIterator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ImmutableSortedSet<E>
extends ImmutableSortedSetFauxverideShim<E>
implements SortedIterable<E>,
NavigableSet<E> {
    final transient Comparator<? super E> comparator;
    @LazyInit
    @CheckForNull
    transient ImmutableSortedSet<E> descendingSet;

    static <E> RegularImmutableSortedSet<E> emptySet(Comparator<? super E> comparator) {
        if (Ordering.natural().equals(comparator)) {
            return RegularImmutableSortedSet.NATURAL_EMPTY_SET;
        }
        return new RegularImmutableSortedSet<E>(ImmutableList.of(), comparator);
    }

    public static <E extends Comparable<?>> Builder<E> naturalOrder() {
        return new Builder(Ordering.natural());
    }

    int unsafeCompare(Object a, @CheckForNull Object b) {
        return ImmutableSortedSet.unsafeCompare(this.comparator, a, b);
    }

    static int unsafeCompare(Comparator<?> comparator, Object a, @CheckForNull Object b) {
        Comparator<@Nullable ?> unsafeComparator = comparator;
        return unsafeComparator.compare(a, b);
    }

    ImmutableSortedSet(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    public ImmutableSortedSet<E> headSet(E toElement) {
        return this.headSet((Object)toElement, false);
    }

    @Override
    public ImmutableSortedSet<E> headSet(E toElement, boolean inclusive) {
        return this.headSetImpl(Preconditions.checkNotNull(toElement), inclusive);
    }

    @Override
    public ImmutableSortedSet<E> subSet(E fromElement, E toElement) {
        return this.subSet((Object)fromElement, true, (Object)toElement, false);
    }

    @Override
    public ImmutableSortedSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        Preconditions.checkNotNull(fromElement);
        Preconditions.checkNotNull(toElement);
        Preconditions.checkArgument(this.comparator.compare(fromElement, toElement) <= 0);
        return this.subSetImpl(fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public ImmutableSortedSet<E> tailSet(E fromElement) {
        return this.tailSet((Object)fromElement, true);
    }

    @Override
    public ImmutableSortedSet<E> tailSet(E fromElement, boolean inclusive) {
        return this.tailSetImpl(Preconditions.checkNotNull(fromElement), inclusive);
    }

    abstract ImmutableSortedSet<E> headSetImpl(E var1, boolean var2);

    abstract ImmutableSortedSet<E> subSetImpl(E var1, boolean var2, E var3, boolean var4);

    abstract ImmutableSortedSet<E> tailSetImpl(E var1, boolean var2);

    @Override
    @CheckForNull
    public E lower(E e) {
        return Iterators.getNext(((ImmutableSortedSet)this.headSet((Object)e, false)).descendingIterator(), null);
    }

    @Override
    @CheckForNull
    public E floor(E e) {
        return Iterators.getNext(((ImmutableSortedSet)this.headSet((Object)e, true)).descendingIterator(), null);
    }

    @Override
    @CheckForNull
    public E ceiling(E e) {
        return Iterables.getFirst(this.tailSet((Object)e, true), null);
    }

    @Override
    @CheckForNull
    public E higher(E e) {
        return Iterables.getFirst(this.tailSet((Object)e, false), null);
    }

    @Override
    public E first() {
        return this.iterator().next();
    }

    @Override
    public E last() {
        return this.descendingIterator().next();
    }

    @Override
    @Deprecated
    @CheckForNull
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final E pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CheckForNull
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final E pollLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableSortedSet<E> descendingSet() {
        ImmutableSortedSet<E> result = this.descendingSet;
        if (result == null) {
            result = this.descendingSet = this.createDescendingSet();
            result.descendingSet = this;
        }
        return result;
    }

    abstract ImmutableSortedSet<E> createDescendingSet();

    @Override
    public Spliterator<E> spliterator() {
        return new Spliterators.AbstractSpliterator<E>(this.size(), 1365){
            final UnmodifiableIterator<E> iterator;
            {
                this.iterator = ImmutableSortedSet.this.iterator();
            }

            @Override
            public boolean tryAdvance(Consumer<? super E> action) {
                if (this.iterator.hasNext()) {
                    action.accept(this.iterator.next());
                    return true;
                }
                return false;
            }

            @Override
            public Comparator<? super E> getComparator() {
                return ImmutableSortedSet.this.comparator;
            }
        };
    }

    @Override
    public abstract UnmodifiableIterator<E> descendingIterator();

    abstract int indexOf(@CheckForNull Object var1);

    public static final class Builder<E>
    extends ImmutableSet.Builder<E> {
        private final Comparator<? super E> comparator;
        private E[] elements;
        private int n;

        public Builder(Comparator<? super E> comparator) {
            super(true);
            this.comparator = Preconditions.checkNotNull(comparator);
            this.elements = new Object[4];
            this.n = 0;
        }

        @Override
        void copy() {
            this.elements = Arrays.copyOf(this.elements, this.elements.length);
        }

        private void sortAndDedup() {
            if (this.n == 0) {
                return;
            }
            Arrays.sort(this.elements, 0, this.n, this.comparator);
            int unique = 1;
            for (int i = 1; i < this.n; ++i) {
                int cmp = this.comparator.compare(this.elements[unique - 1], this.elements[i]);
                if (cmp < 0) {
                    this.elements[unique++] = this.elements[i];
                    continue;
                }
                if (cmp <= 0) continue;
                String string = String.valueOf(this.comparator);
                throw new AssertionError((Object)new StringBuilder(48 + String.valueOf(string).length()).append("Comparator ").append(string).append(" compare method violates its contract").toString());
            }
            Arrays.fill(this.elements, unique, this.n, null);
            this.n = unique;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> add(E element) {
            Preconditions.checkNotNull(element);
            this.copyIfNecessary();
            if (this.n == this.elements.length) {
                this.sortAndDedup();
                int newLength = ImmutableCollection.Builder.expandedCapacity(this.n, this.n + 1);
                if (newLength > this.elements.length) {
                    this.elements = Arrays.copyOf(this.elements, newLength);
                }
            }
            this.elements[this.n++] = element;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterable<? extends E> elements) {
            super.addAll((Iterable)elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterator<? extends E> elements) {
            super.addAll((Iterator)elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        Builder<E> combine(ImmutableSet.Builder<E> builder) {
            this.copyIfNecessary();
            Builder other = (Builder)builder;
            for (int i = 0; i < other.n; ++i) {
                this.add((Object)other.elements[i]);
            }
            return this;
        }

        @Override
        public ImmutableSortedSet<E> build() {
            this.sortAndDedup();
            if (this.n == 0) {
                return ImmutableSortedSet.emptySet(this.comparator);
            }
            this.forceCopy = true;
            return new RegularImmutableSortedSet<E>(ImmutableList.asImmutableList(this.elements, this.n), this.comparator);
        }
    }
}

