/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.guava.escape;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.escape.ArrayBasedCharEscaper;
import com.linecorp.centraldogma.internal.shaded.guava.escape.CharEscaper;
import com.linecorp.centraldogma.internal.shaded.guava.escape.Escaper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;

public final class Escapers {
    private static final Escaper NULL_ESCAPER = new CharEscaper(){

        @Override
        public String escape(String string) {
            return Preconditions.checkNotNull(string);
        }

        @Override
        @CheckForNull
        protected char[] escape(char c) {
            return null;
        }
    };

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<Character, String> replacementMap = new HashMap<Character, String>();
        private char safeMin = '\u0000';
        private char safeMax = (char)65535;
        @CheckForNull
        private String unsafeReplacement = null;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder addEscape(char c, String replacement) {
            Preconditions.checkNotNull(replacement);
            this.replacementMap.put(Character.valueOf(c), replacement);
            return this;
        }

        public Escaper build() {
            return new ArrayBasedCharEscaper(this.replacementMap, this.safeMin, this.safeMax){
                @CheckForNull
                private final char[] replacementChars;
                {
                    super(replacementMap, safeMin, safeMax);
                    this.replacementChars = unsafeReplacement != null ? unsafeReplacement.toCharArray() : null;
                }

                @Override
                @CheckForNull
                protected char[] escapeUnsafe(char c) {
                    return this.replacementChars;
                }
            };
        }
    }
}

