/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.guava.io;

import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.centraldogma.internal.shaded.guava.graph.SuccessorsFunction;
import com.linecorp.centraldogma.internal.shaded.guava.io.ByteSink;
import com.linecorp.centraldogma.internal.shaded.guava.io.CharSink;
import com.linecorp.centraldogma.internal.shaded.guava.io.FileWriteMode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;

public final class Files {
    private static final SuccessorsFunction<File> FILE_TREE = new SuccessorsFunction<File>(){};

    public static ByteSink asByteSink(File file, FileWriteMode ... modes) {
        return new FileByteSink(file, modes);
    }

    public static CharSink asCharSink(File file, Charset charset, FileWriteMode ... modes) {
        return Files.asByteSink(file, modes).asCharSink(charset);
    }

    private static final class FileByteSink
    extends ByteSink {
        private final File file;
        private final ImmutableSet<FileWriteMode> modes;

        private FileByteSink(File file, FileWriteMode ... modes) {
            this.file = Preconditions.checkNotNull(file);
            this.modes = ImmutableSet.copyOf(modes);
        }

        @Override
        public FileOutputStream openStream() throws IOException {
            return new FileOutputStream(this.file, this.modes.contains((Object)FileWriteMode.APPEND));
        }

        public String toString() {
            String string = String.valueOf(this.file);
            String string2 = String.valueOf(this.modes);
            return new StringBuilder(20 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Files.asByteSink(").append(string).append(", ").append(string2).append(")").toString();
        }
    }
}

