/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.guava.io;

import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public final class Resources {
    public static ByteSource asByteSource(URL url) {
        return new UrlByteSource(url);
    }

    public static byte[] toByteArray(URL url) throws IOException {
        return Resources.asByteSource(url).read();
    }

    private static final class UrlByteSource
    extends ByteSource {
        private final URL url;

        private UrlByteSource(URL url) {
            this.url = Preconditions.checkNotNull(url);
        }

        @Override
        public InputStream openStream() throws IOException {
            return this.url.openStream();
        }

        public String toString() {
            String string = String.valueOf(this.url);
            return new StringBuilder(24 + String.valueOf(string).length()).append("Resources.asByteSource(").append(string).append(")").toString();
        }
    }
}

