/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.jsonpath;

import com.linecorp.centraldogma.internal.shaded.jsonpath.EvaluationListener;
import com.linecorp.centraldogma.internal.shaded.jsonpath.Option;
import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.DefaultsImpl;
import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.Utils;
import com.linecorp.centraldogma.internal.shaded.jsonpath.spi.json.JsonProvider;
import com.linecorp.centraldogma.internal.shaded.jsonpath.spi.mapper.MappingProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class Configuration {
    private static Defaults DEFAULTS = null;
    private final JsonProvider jsonProvider;
    private final MappingProvider mappingProvider;
    private final Set<Option> options;
    private final Collection<EvaluationListener> evaluationListeners;

    public static synchronized void setDefaults(Defaults defaults) {
        DEFAULTS = defaults;
    }

    private static Defaults getEffectiveDefaults() {
        if (DEFAULTS == null) {
            return DefaultsImpl.INSTANCE;
        }
        return DEFAULTS;
    }

    private Configuration(JsonProvider jsonProvider, MappingProvider mappingProvider, EnumSet<Option> options, Collection<EvaluationListener> evaluationListeners) {
        Utils.notNull(jsonProvider, "jsonProvider can not be null", new Object[0]);
        Utils.notNull(mappingProvider, "mappingProvider can not be null", new Object[0]);
        Utils.notNull(options, "setOptions can not be null", new Object[0]);
        Utils.notNull(evaluationListeners, "evaluationListeners can not be null", new Object[0]);
        this.jsonProvider = jsonProvider;
        this.mappingProvider = mappingProvider;
        this.options = Collections.unmodifiableSet(options);
        this.evaluationListeners = Collections.unmodifiableCollection(evaluationListeners);
    }

    public Collection<EvaluationListener> getEvaluationListeners() {
        return this.evaluationListeners;
    }

    public JsonProvider jsonProvider() {
        return this.jsonProvider;
    }

    public MappingProvider mappingProvider() {
        return this.mappingProvider;
    }

    public Set<Option> getOptions() {
        return this.options;
    }

    public boolean containsOption(Option option) {
        return this.options.contains((Object)option);
    }

    public static Configuration defaultConfiguration() {
        Defaults defaults = Configuration.getEffectiveDefaults();
        return Configuration.builder().jsonProvider(defaults.jsonProvider()).options(defaults.options()).build();
    }

    public static ConfigurationBuilder builder() {
        return new ConfigurationBuilder();
    }

    public static interface Defaults {
        public JsonProvider jsonProvider();

        public Set<Option> options();

        public MappingProvider mappingProvider();
    }

    public static class ConfigurationBuilder {
        private JsonProvider jsonProvider;
        private MappingProvider mappingProvider;
        private EnumSet<Option> options = EnumSet.noneOf(Option.class);
        private Collection<EvaluationListener> evaluationListener = new ArrayList<EvaluationListener>();

        public ConfigurationBuilder jsonProvider(JsonProvider provider) {
            this.jsonProvider = provider;
            return this;
        }

        public ConfigurationBuilder mappingProvider(MappingProvider provider) {
            this.mappingProvider = provider;
            return this;
        }

        public ConfigurationBuilder options(Option ... flags) {
            if (flags.length > 0) {
                this.options.addAll(Arrays.asList(flags));
            }
            return this;
        }

        public ConfigurationBuilder options(Set<Option> options) {
            this.options.addAll(options);
            return this;
        }

        public Configuration build() {
            if (this.jsonProvider == null || this.mappingProvider == null) {
                Defaults defaults = Configuration.getEffectiveDefaults();
                if (this.jsonProvider == null) {
                    this.jsonProvider = defaults.jsonProvider();
                }
                if (this.mappingProvider == null) {
                    this.mappingProvider = defaults.mappingProvider();
                }
            }
            return new Configuration(this.jsonProvider, this.mappingProvider, this.options, this.evaluationListener);
        }
    }
}

