/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.jsonpath;

import com.linecorp.centraldogma.internal.shaded.jsonpath.Configuration;
import com.linecorp.centraldogma.internal.shaded.jsonpath.DocumentContext;
import com.linecorp.centraldogma.internal.shaded.jsonpath.JsonPathException;
import com.linecorp.centraldogma.internal.shaded.jsonpath.Option;
import com.linecorp.centraldogma.internal.shaded.jsonpath.Predicate;
import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.JsonContext;
import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.Path;
import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.Utils;
import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.path.PathCompiler;

public class JsonPath {
    private final Path path;

    private JsonPath(String jsonPath, Predicate[] filters) {
        Utils.notNull(jsonPath, "path can not be null", new Object[0]);
        this.path = PathCompiler.compile(jsonPath, filters);
    }

    public <T> T read(Object jsonObject, Configuration configuration) {
        boolean optAsPathList = configuration.containsOption(Option.AS_PATH_LIST);
        boolean optAlwaysReturnList = configuration.containsOption(Option.ALWAYS_RETURN_LIST);
        boolean optSuppressExceptions = configuration.containsOption(Option.SUPPRESS_EXCEPTIONS);
        try {
            if (this.path.isFunctionPath()) {
                if (optAsPathList || optAlwaysReturnList) {
                    throw new JsonPathException("Options " + (Object)((Object)Option.AS_PATH_LIST) + " and " + (Object)((Object)Option.ALWAYS_RETURN_LIST) + " are not allowed when using path functions!");
                }
                return this.path.evaluate(jsonObject, jsonObject, configuration).getValue(true);
            }
            if (optAsPathList) {
                return this.path.evaluate(jsonObject, jsonObject, configuration).getPath();
            }
            Object res = this.path.evaluate(jsonObject, jsonObject, configuration).getValue(false);
            if (optAlwaysReturnList && this.path.isDefinite()) {
                Object array = configuration.jsonProvider().createArray();
                configuration.jsonProvider().setArrayIndex(array, 0, res);
                return (T)array;
            }
            return res;
        }
        catch (RuntimeException e) {
            if (!optSuppressExceptions) {
                throw e;
            }
            if (optAsPathList) {
                return (T)configuration.jsonProvider().createArray();
            }
            if (optAlwaysReturnList) {
                return (T)configuration.jsonProvider().createArray();
            }
            return (T)(this.path.isDefinite() ? null : configuration.jsonProvider().createArray());
        }
    }

    public static JsonPath compile(String jsonPath, Predicate ... filters) {
        Utils.notEmpty(jsonPath, "json can not be null or empty", new Object[0]);
        return new JsonPath(jsonPath, filters);
    }

    public static DocumentContext parse(Object json, Configuration configuration) {
        return new JsonContext(configuration).parse(json);
    }
}

