/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.jsonpath.internal;

import com.linecorp.centraldogma.internal.shaded.jsonpath.InvalidPathException;

public class CharacterIndex {
    private final CharSequence charSequence;
    private int position;

    public CharacterIndex(CharSequence charSequence) {
        this.charSequence = charSequence;
        this.position = 0;
    }

    public int length() {
        return this.charSequence.length();
    }

    public char charAt(int idx) {
        return this.charSequence.charAt(idx);
    }

    public char currentChar() {
        return this.charSequence.charAt(this.position);
    }

    public boolean currentCharIs(char c) {
        return this.charSequence.charAt(this.position) == c;
    }

    public boolean nextCharIs(char c) {
        return this.inBounds(this.position + 1) && this.charSequence.charAt(this.position + 1) == c;
    }

    public int incrementPosition(int charCount) {
        return this.setPosition(this.position + charCount);
    }

    public int setPosition(int newPosition) {
        this.position = newPosition;
        return this.position;
    }

    public int position() {
        return this.position;
    }

    public int indexOfMatchingCloseChar(int startPosition, char openChar, char closeChar, boolean skipStrings, boolean skipRegex) {
        if (this.charAt(startPosition) != openChar) {
            throw new InvalidPathException("Expected " + openChar + " but found " + this.charAt(startPosition));
        }
        int opened = 1;
        int readPosition = startPosition + 1;
        while (this.inBounds(readPosition)) {
            char quoteChar;
            if (skipStrings && ((quoteChar = this.charAt(readPosition)) == '\'' || quoteChar == '\"')) {
                if ((readPosition = this.nextIndexOfUnescaped(readPosition, quoteChar)) == -1) {
                    throw new InvalidPathException("Could not find matching close quote for " + quoteChar + " when parsing : " + this.charSequence);
                }
                ++readPosition;
            }
            if (skipRegex && this.charAt(readPosition) == '/') {
                if ((readPosition = this.nextIndexOfUnescaped(readPosition, '/')) == -1) {
                    throw new InvalidPathException("Could not find matching close for / when parsing regex in : " + this.charSequence);
                }
                ++readPosition;
            }
            if (this.charAt(readPosition) == openChar) {
                ++opened;
            }
            if (this.charAt(readPosition) == closeChar && --opened == 0) {
                return readPosition;
            }
            ++readPosition;
        }
        return -1;
    }

    public int indexOfClosingBracket(int startPosition, boolean skipStrings, boolean skipRegex) {
        return this.indexOfMatchingCloseChar(startPosition, '(', ')', skipStrings, skipRegex);
    }

    public int indexOfNextSignificantChar(char c) {
        return this.indexOfNextSignificantChar(this.position, c);
    }

    public int indexOfNextSignificantChar(int startPosition, char c) {
        int readPosition = startPosition + 1;
        while (!this.isOutOfBounds(readPosition) && this.charAt(readPosition) == ' ') {
            ++readPosition;
        }
        if (this.charAt(readPosition) == c) {
            return readPosition;
        }
        return -1;
    }

    public int nextIndexOf(int startPosition, char c) {
        int readPosition = startPosition;
        while (!this.isOutOfBounds(readPosition)) {
            if (this.charAt(readPosition) == c) {
                return readPosition;
            }
            ++readPosition;
        }
        return -1;
    }

    public int nextIndexOfUnescaped(char c) {
        return this.nextIndexOfUnescaped(this.position, c);
    }

    public int nextIndexOfUnescaped(int startPosition, char c) {
        int readPosition = startPosition + 1;
        boolean inEscape = false;
        while (!this.isOutOfBounds(readPosition)) {
            if (inEscape) {
                inEscape = false;
            } else if ('\\' == this.charAt(readPosition)) {
                inEscape = true;
            } else if (c == this.charAt(readPosition) && !inEscape) {
                return readPosition;
            }
            ++readPosition;
        }
        return -1;
    }

    public boolean nextSignificantCharIs(int startPosition, char c) {
        int readPosition = startPosition + 1;
        while (!this.isOutOfBounds(readPosition) && this.charAt(readPosition) == ' ') {
            ++readPosition;
        }
        return !this.isOutOfBounds(readPosition) && this.charAt(readPosition) == c;
    }

    public boolean nextSignificantCharIs(char c) {
        return this.nextSignificantCharIs(this.position, c);
    }

    public char nextSignificantChar() {
        return this.nextSignificantChar(this.position);
    }

    public char nextSignificantChar(int startPosition) {
        int readPosition = startPosition + 1;
        while (!this.isOutOfBounds(readPosition) && this.charAt(readPosition) == ' ') {
            ++readPosition;
        }
        if (!this.isOutOfBounds(readPosition)) {
            return this.charAt(readPosition);
        }
        return ' ';
    }

    public void readSignificantChar(char c) {
        if (this.skipBlanks().currentChar() != c) {
            throw new InvalidPathException(String.format("Expected character: %c", Character.valueOf(c)));
        }
        this.incrementPosition(1);
    }

    public void readSignificantSubSequence(CharSequence s) {
        this.skipBlanks();
        if (!this.inBounds(this.position + s.length() - 1)) {
            throw new InvalidPathException(String.format("End of string reached while expecting: %s", s));
        }
        if (!this.subSequence(this.position, this.position + s.length()).equals(s)) {
            throw new InvalidPathException(String.format("Expected: %s", s));
        }
        this.incrementPosition(s.length());
    }

    public int indexOfPreviousSignificantChar(int startPosition) {
        int readPosition = startPosition - 1;
        while (!this.isOutOfBounds(readPosition) && this.charAt(readPosition) == ' ') {
            --readPosition;
        }
        if (!this.isOutOfBounds(readPosition)) {
            return readPosition;
        }
        return -1;
    }

    public int indexOfPreviousSignificantChar() {
        return this.indexOfPreviousSignificantChar(this.position);
    }

    public char previousSignificantChar(int startPosition) {
        int previousSignificantCharIndex = this.indexOfPreviousSignificantChar(startPosition);
        if (previousSignificantCharIndex == -1) {
            return ' ';
        }
        return this.charAt(previousSignificantCharIndex);
    }

    public char previousSignificantChar() {
        return this.previousSignificantChar(this.position);
    }

    public boolean currentIsTail() {
        return this.position >= this.charSequence.length() - 1;
    }

    public boolean hasMoreCharacters() {
        return this.inBounds(this.position + 1);
    }

    public boolean inBounds(int idx) {
        return idx >= 0 && idx < this.charSequence.length();
    }

    public boolean inBounds() {
        return this.inBounds(this.position);
    }

    public boolean isOutOfBounds(int idx) {
        return !this.inBounds(idx);
    }

    public CharSequence subSequence(int start, int end) {
        return this.charSequence.subSequence(start, end);
    }

    public String toString() {
        return this.charSequence.toString();
    }

    public boolean isNumberCharacter(int readPosition) {
        char c = this.charAt(readPosition);
        return Character.isDigit(c) || c == '-' || c == '.';
    }

    public CharacterIndex skipBlanks() {
        while (this.inBounds() && this.currentChar() == ' ') {
            this.incrementPosition(1);
        }
        return this;
    }
}

