/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.jsonpath.internal;

import com.linecorp.centraldogma.internal.shaded.jsonpath.Configuration;
import com.linecorp.centraldogma.internal.shaded.jsonpath.DocumentContext;
import com.linecorp.centraldogma.internal.shaded.jsonpath.JsonPath;
import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonContext
implements DocumentContext {
    private static final Logger logger = LoggerFactory.getLogger(JsonContext.class);
    private final Configuration configuration;
    private Object json;

    public JsonContext() {
        this(Configuration.defaultConfiguration());
    }

    public JsonContext(Configuration configuration) {
        Utils.notNull(configuration, "configuration can not be null", new Object[0]);
        this.configuration = configuration;
    }

    public DocumentContext parse(Object json) {
        Utils.notNull(json, "json object can not be null", new Object[0]);
        this.json = json;
        return this;
    }

    public <T> T read(JsonPath path) {
        Utils.notNull(path, "path can not be null", new Object[0]);
        return path.read(this.json, this.configuration);
    }

    @Override
    public <T> T read(JsonPath path, Class<T> type) {
        return this.convert(this.read(path), type, this.configuration);
    }

    private <T> T convert(Object obj, Class<T> targetType, Configuration configuration) {
        return configuration.mappingProvider().map(obj, targetType, configuration);
    }
}

