/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.jsonpath.internal;

import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.Utils;
import java.util.Collection;

public abstract class PathRef
implements Comparable<PathRef> {
    public static final PathRef NO_OP = new PathRef(null){

        @Override
        public Object getAccessor() {
            return null;
        }
    };
    protected Object parent;

    private PathRef(Object parent) {
        this.parent = parent;
    }

    abstract Object getAccessor();

    @Override
    public int compareTo(PathRef o) {
        return this.getAccessor().toString().compareTo(o.getAccessor().toString()) * -1;
    }

    public static PathRef create(Object obj, String property) {
        return new ObjectPropertyPathRef(obj, property);
    }

    public static PathRef create(Object obj, Collection<String> properties) {
        return new ObjectMultiPropertyPathRef(obj, properties);
    }

    public static PathRef create(Object array, int index) {
        return new ArrayIndexPathRef(array, index);
    }

    public static PathRef createRoot(Object root) {
        return new RootPathRef(root);
    }

    private static class ObjectMultiPropertyPathRef
    extends PathRef {
        private Collection<String> properties;

        private ObjectMultiPropertyPathRef(Object parent, Collection<String> properties) {
            super(parent);
            this.properties = properties;
        }

        @Override
        public Object getAccessor() {
            return Utils.join("&&", this.properties);
        }
    }

    private static class ObjectPropertyPathRef
    extends PathRef {
        private String property;

        private ObjectPropertyPathRef(Object parent, String property) {
            super(parent);
            this.property = property;
        }

        @Override
        public Object getAccessor() {
            return this.property;
        }
    }

    private static class ArrayIndexPathRef
    extends PathRef {
        private int index;

        private ArrayIndexPathRef(Object parent, int index) {
            super(parent);
            this.index = index;
        }

        @Override
        public Object getAccessor() {
            return this.index;
        }

        @Override
        public int compareTo(PathRef o) {
            if (o instanceof ArrayIndexPathRef) {
                ArrayIndexPathRef pf = (ArrayIndexPathRef)o;
                return Integer.valueOf(pf.index).compareTo(this.index);
            }
            return super.compareTo(o);
        }
    }

    private static class RootPathRef
    extends PathRef {
        private RootPathRef(Object parent) {
            super(parent);
        }

        @Override
        Object getAccessor() {
            return "$";
        }
    }
}

