/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.jsonpath.internal.filter;

import com.linecorp.centraldogma.internal.shaded.jsonpath.Filter;
import com.linecorp.centraldogma.internal.shaded.jsonpath.InvalidPathException;
import com.linecorp.centraldogma.internal.shaded.jsonpath.Predicate;
import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.CharacterIndex;
import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.filter.ExpressionNode;
import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.filter.LogicalExpressionNode;
import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.filter.LogicalOperator;
import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.filter.RelationalExpressionNode;
import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.filter.RelationalOperator;
import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.filter.ValueNode;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterCompiler {
    private static final Logger logger = LoggerFactory.getLogger(FilterCompiler.class);
    private CharacterIndex filter;

    public static Filter compile(String filterString) {
        FilterCompiler compiler = new FilterCompiler(filterString);
        return new CompiledFilter(compiler.compile());
    }

    private FilterCompiler(String filterString) {
        filterString = filterString.trim();
        if (!filterString.startsWith("[") || !filterString.endsWith("]")) {
            throw new InvalidPathException("Filter must start with '[' and end with ']'. " + filterString);
        }
        if (!(filterString = filterString.substring(1, filterString.length() - 1).trim()).startsWith("?")) {
            throw new InvalidPathException("Filter must start with '[?' and end with ']'. " + filterString);
        }
        if (!(filterString = filterString.substring(1).trim()).startsWith("(") || !filterString.endsWith(")")) {
            throw new InvalidPathException("Filter must start with '[?(' and end with ')]'. " + filterString);
        }
        this.filter = new CharacterIndex(filterString);
    }

    public Predicate compile() {
        try {
            ExpressionNode result = this.readLogicalOR();
            this.filter.skipBlanks();
            if (this.filter.inBounds()) {
                throw new InvalidPathException(String.format("Expected end of filter expression instead of: %s", this.filter.subSequence(this.filter.position(), this.filter.length())));
            }
            return result;
        }
        catch (InvalidPathException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidPathException("Failed to parse filter: " + this.filter + ", error on position: " + this.filter.position() + ", char: " + this.filter.currentChar());
        }
    }

    private ValueNode readValueNode() {
        switch (this.filter.skipBlanks().currentChar()) {
            case '$': {
                return this.readPath();
            }
            case '@': {
                return this.readPath();
            }
            case '!': {
                this.filter.incrementPosition(1);
                switch (this.filter.skipBlanks().currentChar()) {
                    case '$': {
                        return this.readPath();
                    }
                    case '@': {
                        return this.readPath();
                    }
                }
                throw new InvalidPathException(String.format("Unexpected character: %c", Character.valueOf('!')));
            }
        }
        return this.readLiteral();
    }

    private ValueNode readLiteral() {
        switch (this.filter.skipBlanks().currentChar()) {
            case '\'': {
                return this.readStringLiteral('\'');
            }
            case '\"': {
                return this.readStringLiteral('\"');
            }
            case 't': {
                return this.readBooleanLiteral();
            }
            case 'f': {
                return this.readBooleanLiteral();
            }
            case '-': {
                return this.readNumberLiteral();
            }
            case 'n': {
                return this.readNullLiteral();
            }
            case '{': {
                return this.readJsonLiteral();
            }
            case '[': {
                return this.readJsonLiteral();
            }
            case '/': {
                return this.readPattern();
            }
        }
        return this.readNumberLiteral();
    }

    private ExpressionNode readLogicalOR() {
        ArrayList<ExpressionNode> ops = new ArrayList<ExpressionNode>();
        ops.add(this.readLogicalAND());
        while (true) {
            int savepoint = this.filter.position();
            try {
                this.filter.readSignificantSubSequence(LogicalOperator.OR.getOperatorString());
                ops.add(this.readLogicalAND());
            }
            catch (InvalidPathException exc) {
                this.filter.setPosition(savepoint);
                return 1 == ops.size() ? (ExpressionNode)ops.get(0) : LogicalExpressionNode.createLogicalOr(ops);
            }
        }
    }

    private ExpressionNode readLogicalAND() {
        ArrayList<ExpressionNode> ops = new ArrayList<ExpressionNode>();
        ops.add(this.readLogicalANDOperand());
        while (true) {
            int savepoint = this.filter.position();
            try {
                this.filter.readSignificantSubSequence(LogicalOperator.AND.getOperatorString());
                ops.add(this.readLogicalANDOperand());
            }
            catch (InvalidPathException exc) {
                this.filter.setPosition(savepoint);
                return 1 == ops.size() ? (ExpressionNode)ops.get(0) : LogicalExpressionNode.createLogicalAnd(ops);
            }
        }
    }

    private ExpressionNode readLogicalANDOperand() {
        if (this.filter.skipBlanks().currentCharIs('(')) {
            this.filter.readSignificantChar('(');
            ExpressionNode op = this.readLogicalOR();
            this.filter.readSignificantChar(')');
            return op;
        }
        return this.readExpression();
    }

    private RelationalExpressionNode readExpression() {
        ValueNode left = this.readValueNode();
        int savepoint = this.filter.position();
        try {
            RelationalOperator operator = this.readRelationalOperator();
            ValueNode right = this.readValueNode();
            return new RelationalExpressionNode(left, operator, right);
        }
        catch (InvalidPathException exc) {
            this.filter.setPosition(savepoint);
            ValueNode.PathNode pathNode = left.asPathNode();
            left = pathNode.asExistsCheck(pathNode.shouldExists());
            RelationalOperator operator = RelationalOperator.EXISTS;
            ValueNode.BooleanNode right = left.asPathNode().shouldExists() ? ValueNode.TRUE : ValueNode.FALSE;
            return new RelationalExpressionNode(left, operator, right);
        }
    }

    private RelationalOperator readRelationalOperator() {
        int begin = this.filter.skipBlanks().position();
        if (this.isRelationalOperatorChar(this.filter.currentChar())) {
            while (this.filter.inBounds() && this.isRelationalOperatorChar(this.filter.currentChar())) {
                this.filter.incrementPosition(1);
            }
        } else {
            while (this.filter.inBounds() && this.filter.currentChar() != ' ') {
                this.filter.incrementPosition(1);
            }
        }
        CharSequence operator = this.filter.subSequence(begin, this.filter.position());
        logger.trace("Operator from {} to {} -> [{}]", new Object[]{begin, this.filter.position() - 1, operator});
        return RelationalOperator.fromString(operator.toString());
    }

    private ValueNode.NullNode readNullLiteral() {
        CharSequence nullValue;
        int begin = this.filter.position();
        if (this.filter.currentChar() == 'n' && this.filter.inBounds(this.filter.position() + 3) && "null".equals((nullValue = this.filter.subSequence(this.filter.position(), this.filter.position() + 4)).toString())) {
            logger.trace("NullLiteral from {} to {} -> [{}]", new Object[]{begin, this.filter.position() + 3, nullValue});
            this.filter.incrementPosition(nullValue.length());
            return ValueNode.createNullNode();
        }
        throw new InvalidPathException("Expected <null> value");
    }

    private ValueNode.JsonNode readJsonLiteral() {
        int begin = this.filter.position();
        char openChar = this.filter.currentChar();
        assert (openChar == '[' || openChar == '{');
        char closeChar = openChar == '[' ? (char)']' : '}';
        int closingIndex = this.filter.indexOfMatchingCloseChar(this.filter.position(), openChar, closeChar, true, false);
        if (closingIndex == -1) {
            throw new InvalidPathException("String not closed. Expected ' in " + this.filter);
        }
        this.filter.setPosition(closingIndex + 1);
        CharSequence json = this.filter.subSequence(begin, this.filter.position());
        logger.trace("JsonLiteral from {} to {} -> [{}]", new Object[]{begin, this.filter.position(), json});
        return ValueNode.createJsonNode(json);
    }

    private ValueNode.PatternNode readPattern() {
        int begin = this.filter.position();
        int closingIndex = this.filter.nextIndexOfUnescaped('/');
        if (closingIndex == -1) {
            throw new InvalidPathException("Pattern not closed. Expected / in " + this.filter);
        }
        if (this.filter.inBounds(closingIndex + 1) && this.filter.charAt(closingIndex + 1) == 'i') {
            ++closingIndex;
        }
        this.filter.setPosition(closingIndex + 1);
        CharSequence pattern = this.filter.subSequence(begin, this.filter.position());
        logger.trace("PatternNode from {} to {} -> [{}]", new Object[]{begin, this.filter.position(), pattern});
        return ValueNode.createPatternNode(pattern);
    }

    private ValueNode.StringNode readStringLiteral(char endChar) {
        int begin = this.filter.position();
        int closingSingleQuoteIndex = this.filter.nextIndexOfUnescaped(endChar);
        if (closingSingleQuoteIndex == -1) {
            throw new InvalidPathException("String literal does not have matching quotes. Expected " + endChar + " in " + this.filter);
        }
        this.filter.setPosition(closingSingleQuoteIndex + 1);
        CharSequence stringLiteral = this.filter.subSequence(begin, this.filter.position());
        logger.trace("StringLiteral from {} to {} -> [{}]", new Object[]{begin, this.filter.position(), stringLiteral});
        return ValueNode.createStringNode(stringLiteral, true);
    }

    private ValueNode.NumberNode readNumberLiteral() {
        int begin = this.filter.position();
        while (this.filter.inBounds() && this.filter.isNumberCharacter(this.filter.position())) {
            this.filter.incrementPosition(1);
        }
        CharSequence numberLiteral = this.filter.subSequence(begin, this.filter.position());
        logger.trace("NumberLiteral from {} to {} -> [{}]", new Object[]{begin, this.filter.position(), numberLiteral});
        return ValueNode.createNumberNode(numberLiteral);
    }

    private ValueNode.BooleanNode readBooleanLiteral() {
        int end;
        int begin = this.filter.position();
        int n = end = this.filter.currentChar() == 't' ? this.filter.position() + 3 : this.filter.position() + 4;
        if (!this.filter.inBounds(end)) {
            throw new InvalidPathException("Expected boolean literal");
        }
        CharSequence boolValue = this.filter.subSequence(begin, end + 1);
        if (!boolValue.equals("true") && !boolValue.equals("false")) {
            throw new InvalidPathException("Expected boolean literal");
        }
        this.filter.incrementPosition(boolValue.length());
        logger.trace("BooleanLiteral from {} to {} -> [{}]", new Object[]{begin, end, boolValue});
        return ValueNode.createBooleanNode(boolValue);
    }

    private ValueNode.PathNode readPath() {
        char previousSignificantChar = this.filter.previousSignificantChar();
        int begin = this.filter.position();
        this.filter.incrementPosition(1);
        while (this.filter.inBounds()) {
            boolean closingLogicalBracket;
            if (this.filter.currentChar() == '[') {
                int closingSquareBracketIndex = this.filter.indexOfMatchingCloseChar(this.filter.position(), '[', ']', true, false);
                if (closingSquareBracketIndex == -1) {
                    throw new InvalidPathException("Square brackets does not match in filter " + this.filter);
                }
                this.filter.setPosition(closingSquareBracketIndex + 1);
            }
            boolean closingFunctionBracket = this.filter.currentChar() == ')' && this.currentCharIsClosingFunctionBracket(begin);
            boolean bl = closingLogicalBracket = this.filter.currentChar() == ')' && !closingFunctionBracket;
            if (!this.filter.inBounds() || this.isRelationalOperatorChar(this.filter.currentChar()) || this.filter.currentChar() == ' ' || closingLogicalBracket) break;
            this.filter.incrementPosition(1);
        }
        boolean shouldExists = previousSignificantChar != '!';
        CharSequence path = this.filter.subSequence(begin, this.filter.position());
        return ValueNode.createPathNode(path, false, shouldExists);
    }

    private boolean currentCharIsClosingFunctionBracket(int lowerBound) {
        if (this.filter.currentChar() != ')') {
            return false;
        }
        int idx = this.filter.indexOfPreviousSignificantChar();
        if (idx == -1 || this.filter.charAt(idx) != '(') {
            return false;
        }
        --idx;
        while (this.filter.inBounds(idx) && idx > lowerBound) {
            if (this.filter.charAt(idx) == '.') {
                return true;
            }
            --idx;
        }
        return false;
    }

    private boolean isRelationalOperatorChar(char c) {
        return c == '<' || c == '>' || c == '=' || c == '~' || c == '!';
    }

    private static final class CompiledFilter
    extends Filter {
        private final Predicate predicate;

        private CompiledFilter(Predicate predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean apply(Predicate.PredicateContext ctx) {
            return this.predicate.apply(ctx);
        }

        public String toString() {
            String predicateString = this.predicate.toString();
            if (predicateString.startsWith("(")) {
                return "[?" + predicateString + "]";
            }
            return "[?(" + predicateString + ")]";
        }
    }
}

