/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.jsonpath.internal.filter;

import com.linecorp.centraldogma.internal.shaded.jsonpath.Predicate;
import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.Utils;
import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.filter.ExpressionNode;
import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.filter.LogicalOperator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LogicalExpressionNode
extends ExpressionNode {
    protected List<ExpressionNode> chain = new ArrayList<ExpressionNode>();
    private final LogicalOperator operator;

    public static LogicalExpressionNode createLogicalOr(Collection<ExpressionNode> operands) {
        return new LogicalExpressionNode(LogicalOperator.OR, operands);
    }

    public static LogicalExpressionNode createLogicalAnd(Collection<ExpressionNode> operands) {
        return new LogicalExpressionNode(LogicalOperator.AND, operands);
    }

    private LogicalExpressionNode(LogicalOperator operator, Collection<ExpressionNode> operands) {
        this.chain.addAll(operands);
        this.operator = operator;
    }

    public String toString() {
        return "(" + Utils.join(" " + this.operator.getOperatorString() + " ", this.chain) + ")";
    }

    @Override
    public boolean apply(Predicate.PredicateContext ctx) {
        if (this.operator == LogicalOperator.OR) {
            for (ExpressionNode expression : this.chain) {
                if (!expression.apply(ctx)) continue;
                return true;
            }
            return false;
        }
        for (ExpressionNode expression : this.chain) {
            if (expression.apply(ctx)) continue;
            return false;
        }
        return true;
    }
}

