/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.jsonpath.internal.function.numeric;

import com.linecorp.centraldogma.internal.shaded.jsonpath.JsonPathException;
import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.EvaluationContext;
import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.PathRef;
import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.function.Parameter;
import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.function.PathFunction;
import java.util.List;

public abstract class AbstractAggregation
implements PathFunction {
    protected abstract void next(Number var1);

    protected abstract Number getValue();

    @Override
    public Object invoke(String currentPath, PathRef parent, Object model, EvaluationContext ctx, List<Parameter> parameters) {
        int count = 0;
        if (ctx.configuration().jsonProvider().isArray(model)) {
            Iterable<?> objects = ctx.configuration().jsonProvider().toIterable(model);
            for (Object obj : objects) {
                if (!(obj instanceof Number)) continue;
                Number value = (Number)obj;
                ++count;
                this.next(value);
            }
        }
        if (parameters != null) {
            for (Parameter param : parameters) {
                if (!(param.getCachedValue() instanceof Number)) continue;
                Number value = (Number)param.getCachedValue();
                ++count;
                this.next(value);
            }
        }
        if (count != 0) {
            return this.getValue();
        }
        throw new JsonPathException("Aggregation function attempted to calculate value using empty array");
    }
}

