/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.jsonpath.internal.path;

import com.linecorp.centraldogma.internal.shaded.jsonpath.Configuration;
import com.linecorp.centraldogma.internal.shaded.jsonpath.Predicate;
import com.linecorp.centraldogma.internal.shaded.jsonpath.internal.Path;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredicateContextImpl
implements Predicate.PredicateContext {
    private static final Logger logger = LoggerFactory.getLogger(PredicateContextImpl.class);
    private final Object contextDocument;
    private final Object rootDocument;
    private final Configuration configuration;
    private final HashMap<Path, Object> documentPathCache;

    public PredicateContextImpl(Object contextDocument, Object rootDocument, Configuration configuration, HashMap<Path, Object> documentPathCache) {
        this.contextDocument = contextDocument;
        this.rootDocument = rootDocument;
        this.configuration = configuration;
        this.documentPathCache = documentPathCache;
    }

    public Object evaluate(Path path) {
        Object result;
        if (path.isRootPath()) {
            if (this.documentPathCache.containsKey(path)) {
                logger.debug("Using cached result for root path: " + path.toString());
                result = this.documentPathCache.get(path);
            } else {
                result = path.evaluate(this.rootDocument, this.rootDocument, this.configuration).getValue();
                this.documentPathCache.put(path, result);
            }
        } else {
            result = path.evaluate(this.contextDocument, this.rootDocument, this.configuration).getValue();
        }
        return result;
    }

    @Override
    public Object item() {
        return this.contextDocument;
    }

    @Override
    public Object root() {
        return this.rootDocument;
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }
}

