/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.jsonpath.spi.json;

import com.linecorp.centraldogma.internal.shaded.jsonpath.InvalidJsonException;
import com.linecorp.centraldogma.internal.shaded.jsonpath.spi.json.AbstractJsonProvider;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONStyle;
import net.minidev.json.JSONValue;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import net.minidev.json.writer.JsonReaderI;

public class JsonSmartJsonProvider
extends AbstractJsonProvider {
    private final int parseMode;
    private final JsonReaderI<?> mapper;

    public JsonSmartJsonProvider() {
        this(-1, JSONValue.defaultReader.DEFAULT_ORDERED);
    }

    public JsonSmartJsonProvider(int parseMode, JsonReaderI<?> mapper) {
        this.parseMode = parseMode;
        this.mapper = mapper;
    }

    @Override
    public Object createArray() {
        return this.mapper.createArray();
    }

    @Override
    public Object createMap() {
        return this.mapper.createObject();
    }

    @Override
    public Object parse(String json) {
        try {
            return this.createParser().parse(json, this.mapper);
        }
        catch (ParseException e) {
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public String toJson(Object obj) {
        if (obj instanceof Map) {
            return JSONObject.toJSONString((Map)((Map)obj), (JSONStyle)JSONStyle.LT_COMPRESS);
        }
        if (obj instanceof List) {
            return JSONArray.toJSONString((List)((List)obj), (JSONStyle)JSONStyle.LT_COMPRESS);
        }
        throw new UnsupportedOperationException(obj.getClass().getName() + " can not be converted to JSON");
    }

    private JSONParser createParser() {
        return new JSONParser(this.parseMode);
    }
}

