/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.shaded.jsonpath.spi.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.centraldogma.internal.shaded.jsonpath.Configuration;
import com.linecorp.centraldogma.internal.shaded.jsonpath.spi.mapper.MappingException;
import com.linecorp.centraldogma.internal.shaded.jsonpath.spi.mapper.MappingProvider;

public class JacksonMappingProvider
implements MappingProvider {
    private final ObjectMapper objectMapper;

    public JacksonMappingProvider() {
        this(new ObjectMapper());
    }

    public JacksonMappingProvider(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public <T> T map(Object source, Class<T> targetType, Configuration configuration) {
        if (source == null) {
            return null;
        }
        try {
            return (T)this.objectMapper.convertValue(source, targetType);
        }
        catch (Exception e) {
            throw new MappingException(e);
        }
    }
}

