/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.converters.FileConverter;
import com.linecorp.centraldogma.server.CentralDogma;
import com.linecorp.centraldogma.server.CentralDogmaBuilder;
import java.io.File;
import java.io.IOException;
import org.apache.commons.daemon.Daemon;
import org.apache.commons.daemon.DaemonContext;
import org.apache.commons.daemon.DaemonController;
import org.apache.shiro.config.Ini;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main
implements Daemon {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);
    private static final File DEFAULT_DATA_DIR = new File(System.getProperty("user.dir", ".") + File.separatorChar + "data");
    private static final File DEFAULT_CONFIG_FILE = new File(System.getProperty("user.dir", ".") + File.separatorChar + "conf" + File.separatorChar + "dogma.json");
    private static final File DEFAULT_SECURITY_CONFIG_FILE = new File(System.getProperty("user.dir", ".") + File.separatorChar + "conf" + File.separatorChar + "shiro.ini");
    @Parameter(names={"-config"}, description="The path to the config file", converter=FileConverter.class)
    private File configFile;
    @Parameter(names={"-securityConfig"}, description="The path to the security config file", converter=FileConverter.class)
    private File securityConfigFile;
    @Parameter(names={"-help", "-h"}, description="Prints the usage", help=true)
    private Boolean help;
    private State state = State.NONE;
    private CentralDogma dogma;

    public synchronized void init(DaemonContext context) {
        if (this.state != State.NONE) {
            throw new IllegalStateException("initialized already");
        }
        JCommander commander = new JCommander((Object)this);
        commander.setProgramName(this.getClass().getName());
        commander.parse(context.getArguments());
        if (this.help != null && this.help.booleanValue()) {
            commander.usage();
            DaemonController controller = context.getController();
            if (controller != null) {
                controller.fail();
            }
            return;
        }
        this.state = State.INITIALIZED;
    }

    public synchronized void start() throws IOException {
        switch (this.state) {
            case NONE: {
                throw new IllegalStateException("not initialized");
            }
            case STARTED: {
                throw new IllegalStateException("started already");
            }
            case DESTROYED: {
                throw new IllegalStateException("can't start after destruction");
            }
        }
        File configFile = Main.findConfigFile(this.configFile, DEFAULT_CONFIG_FILE);
        File securityConfigFile = Main.findConfigFile(this.securityConfigFile, DEFAULT_SECURITY_CONFIG_FILE);
        Ini securityConfig = securityConfigFile != null ? Ini.fromResourcePath((String)securityConfigFile.getPath()) : null;
        CentralDogma dogma = configFile == null ? new CentralDogmaBuilder(DEFAULT_DATA_DIR).build() : CentralDogma.forConfig(configFile, securityConfig);
        dogma.start();
        this.dogma = dogma;
        this.state = State.STARTED;
    }

    private static File findConfigFile(File file, File defaultFile) {
        if (file != null && file.isFile() && file.canRead()) {
            return file;
        }
        if (defaultFile.isFile() && defaultFile.canRead()) {
            return defaultFile;
        }
        return null;
    }

    public synchronized void stop() {
        switch (this.state) {
            case NONE: 
            case INITIALIZED: 
            case STOPPED: {
                return;
            }
            case DESTROYED: {
                throw new IllegalStateException("can't stop after destruction");
            }
        }
        CentralDogma dogma = this.dogma;
        this.dogma = null;
        dogma.stop();
        this.state = State.STOPPED;
    }

    public void destroy() {
        switch (this.state) {
            case NONE: {
                return;
            }
            case STARTED: {
                throw new IllegalStateException("can't destroy while running");
            }
            case DESTROYED: {
                return;
            }
        }
        this.state = State.DESTROYED;
    }

    public static void main(String[] args) throws Exception {
        final Main main = new Main();
        Runtime.getRuntime().addShutdownHook(new Thread("Central Dogma shutdown hook"){

            @Override
            public void run() {
                try {
                    main.stop();
                }
                catch (Exception e) {
                    logger.warn("Failed to stop the Central Dogma:", (Throwable)e);
                }
                try {
                    main.destroy();
                }
                catch (Exception e) {
                    logger.warn("Failed to destroy the Central Dogma:", (Throwable)e);
                }
            }
        });
        main.init(new DaemonContextImpl(args));
        if (main.state != State.INITIALIZED) {
            System.exit(1);
            return;
        }
        main.start();
    }

    private static final class DaemonContextImpl
    implements DaemonContext {
        private final String[] args;

        DaemonContextImpl(String[] args) {
            this.args = args;
        }

        public DaemonController getController() {
            return null;
        }

        public String[] getArguments() {
            return this.args;
        }
    }

    static enum State {
        NONE,
        INITIALIZED,
        STARTED,
        STOPPED,
        DESTROYED;

    }
}

