/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.linecorp.centraldogma.server.ReplicationConfig;
import com.linecorp.centraldogma.server.ReplicationMethod;
import com.linecorp.centraldogma.server.internal.replication.ZooKeeperCommandExecutor;
import java.util.Objects;

public final class ZooKeeperReplicationConfig
implements ReplicationConfig {
    private final String connectionString;
    private final String pathPrefix;
    private final int timeoutMillis;
    private final int numWorkers;
    private final int maxLogCount;
    private final long minLogAgeMillis;

    public ZooKeeperReplicationConfig(String connectionString, String pathPrefix) {
        this(connectionString, pathPrefix, null, null, null, null);
    }

    public ZooKeeperReplicationConfig(String connectionString, String pathPrefix, int timeoutMillis, int numWorkers, int maxLogCount, long minLogAgeMillis) {
        this(connectionString, pathPrefix, (Integer)timeoutMillis, (Integer)numWorkers, (Integer)maxLogCount, (Long)minLogAgeMillis);
    }

    @JsonCreator
    ZooKeeperReplicationConfig(@JsonProperty(value="connectionString") String connectionString, @JsonProperty(value="pathPrefix") String pathPrefix, @JsonProperty(value="timeoutMillis") Integer timeoutMillis, @JsonProperty(value="numWorkers") Integer numWorkers, @JsonProperty(value="maxLogCount") Integer maxLogCount, @JsonProperty(value="minLogAgeMillis") Long minLogAgeMillis) {
        int timeoutMillisValue;
        this.connectionString = Objects.requireNonNull(connectionString, "connectionString");
        this.pathPrefix = Objects.requireNonNull(pathPrefix, "pathPrefix");
        int n = timeoutMillisValue = timeoutMillis != null ? timeoutMillis : 1000;
        if (timeoutMillisValue <= 0) {
            timeoutMillisValue = 1000;
        }
        this.timeoutMillis = timeoutMillisValue;
        this.numWorkers = numWorkers == null || numWorkers <= 0 ? 16 : numWorkers;
        this.maxLogCount = maxLogCount == null || maxLogCount <= 0 ? 100 : maxLogCount;
        this.minLogAgeMillis = minLogAgeMillis == null || minLogAgeMillis <= 0L ? ZooKeeperCommandExecutor.DEFAULT_MIN_LOG_AGE_MILLIS : minLogAgeMillis;
    }

    @Override
    public ReplicationMethod method() {
        return ReplicationMethod.ZOOKEEPER;
    }

    @JsonProperty
    public String connectionString() {
        return this.connectionString;
    }

    @JsonProperty
    public String pathPrefix() {
        return this.pathPrefix;
    }

    @JsonProperty
    public int timeoutMillis() {
        return this.timeoutMillis;
    }

    @JsonProperty
    public int numWorkers() {
        return this.numWorkers;
    }

    @JsonProperty
    public int maxLogCount() {
        return this.maxLogCount;
    }

    @JsonProperty
    public long minLogAgeMillis() {
        return this.minLogAgeMillis;
    }

    public int hashCode() {
        return this.connectionString().hashCode() * 31 + this.pathPrefix().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ZooKeeperReplicationConfig)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ZooKeeperReplicationConfig that = (ZooKeeperReplicationConfig)obj;
        return this.connectionString().equals(that.connectionString()) && this.pathPrefix().equals(that.pathPrefix()) && this.timeoutMillis() == that.timeoutMillis() && this.numWorkers() == that.numWorkers() && this.maxLogCount() == that.maxLogCount() && this.minLogAgeMillis() == that.minLogAgeMillis();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectionString", (Object)this.connectionString()).add("pathPrefix", (Object)this.pathPrefix()).add("timeoutMillis", this.timeoutMillis()).add("numWorkers", this.numWorkers()).add("maxLogCount", this.maxLogCount()).add("minLogAgeMillis", this.minLogAgeMillis()).toString();
    }
}

