/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.authentication;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.ImmutableMap;
import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.util.Functions;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.auth.AuthTokenExtractors;
import com.linecorp.armeria.server.auth.BasicToken;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.api.v1.AccessToken;
import com.linecorp.centraldogma.server.internal.admin.authentication.CentralDogmaSecurityManager;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.command.Command;
import com.linecorp.centraldogma.server.internal.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.RepositoryCache;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginService
extends AbstractHttpService {
    private static final Logger logger = LoggerFactory.getLogger(LoginService.class);
    private final CentralDogmaSecurityManager securityManager;
    private final CommandExecutor executor;
    private final Function<String, String> loginNameNormalizer;
    private final Cache<String, AccessToken> cache;

    public LoginService(CentralDogmaSecurityManager securityManager, CommandExecutor executor, Function<String, String> loginNameNormalizer, String sessionCacheSpec) {
        this.securityManager = Objects.requireNonNull(securityManager, "securityManager");
        this.executor = Objects.requireNonNull(executor, "executor");
        this.loginNameNormalizer = Objects.requireNonNull(loginNameNormalizer, "loginNameNormalizer");
        this.cache = Caffeine.from((String)RepositoryCache.validateCacheSpec(sessionCacheSpec)).build();
    }

    protected HttpResponse doPost(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        CompletableFuture future = new CompletableFuture();
        ((CompletableFuture)req.aggregate().thenAccept(aMsg -> {
            UsernamePasswordToken usernamePassword;
            try {
                usernamePassword = this.usernamePassword((AggregatedHttpMessage)aMsg);
            }
            catch (HttpResponseException e) {
                future.complete(e.httpResponse());
                return;
            }
            ctx.blockingTaskExecutor().execute(() -> {
                ThreadContext.bind((SecurityManager)this.securityManager);
                Subject currentUser = null;
                boolean success = false;
                try {
                    AccessToken currentUserToken = this.currentUserTokenIfPresent(usernamePassword);
                    if (currentUserToken != null) {
                        future.complete(HttpResponse.of((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (byte[])Jackson.writeValueAsBytes((Object)currentUserToken)));
                        return;
                    }
                    currentUser = new Subject.Builder((SecurityManager)this.securityManager).buildSubject();
                    currentUser.login((AuthenticationToken)usernamePassword);
                    Session currentUserSession = currentUser.getSession(false);
                    long expiresIn = currentUserSession.getTimeout();
                    String sessionId = currentUserSession.getId().toString();
                    SimpleSession session = this.securityManager.getSerializableSession(sessionId);
                    this.executor.execute(Command.createSession(session)).join();
                    success = true;
                    logger.info("{} Logged in: {} ({})", new Object[]{ctx, usernamePassword.getUsername(), sessionId});
                    AccessToken accessToken = new AccessToken(sessionId, expiresIn);
                    this.cache.put((Object)usernamePassword.getUsername(), (Object)accessToken);
                    future.complete(HttpResponse.of((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (byte[])Jackson.writeValueAsBytes((Object)accessToken)));
                }
                catch (IncorrectCredentialsException e) {
                    logger.debug("{} Incorrect login: {}", (Object)ctx, (Object)usernamePassword.getUsername());
                    future.complete(HttpResponse.of((HttpStatus)HttpStatus.UNAUTHORIZED));
                }
                catch (Throwable t) {
                    logger.warn("{} Failed to authenticate: {}", new Object[]{ctx, usernamePassword.getUsername(), t});
                    future.complete(HttpResponse.of((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR));
                }
                finally {
                    try {
                        if (!success && currentUser != null) {
                            currentUser.logout();
                        }
                    }
                    finally {
                        ThreadContext.unbindSecurityManager();
                    }
                }
            });
        })).exceptionally(Functions.voidFunction(cause -> {
            logger.warn("{} Unexpected exception:", (Object)ctx, cause);
            future.complete(HttpResponse.of((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR));
        }));
        return HttpResponse.from(future);
    }

    private UsernamePasswordToken usernamePassword(AggregatedHttpMessage req) {
        BasicToken basicToken = (BasicToken)AuthTokenExtractors.BASIC.apply(req.headers());
        if (basicToken != null) {
            return new UsernamePasswordToken(basicToken.username(), basicToken.password());
        }
        MediaType mediaType = req.headers().contentType();
        if (mediaType != MediaType.FORM_DATA) {
            return (UsernamePasswordToken)LoginService.throwResponseException("invalid_request", "request was missing the '" + MediaType.FORM_DATA + "'.");
        }
        Map parameters = new QueryStringDecoder(req.content().toStringUtf8(), false).parameters();
        List usernames = (List)parameters.get("username");
        List passwords = (List)parameters.get("password");
        if (usernames != null && passwords != null) {
            String username = (String)usernames.get(0);
            String password = (String)passwords.get(0);
            return new UsernamePasswordToken(this.loginNameNormalizer.apply(username), password);
        }
        return (UsernamePasswordToken)LoginService.throwResponseException("invalid_request", "request must contain username and password.");
    }

    @Nullable
    private AccessToken currentUserTokenIfPresent(UsernamePasswordToken usernamePassword) {
        this.securityManager.authenticate((AuthenticationToken)usernamePassword);
        AccessToken currentUserToken = (AccessToken)this.cache.getIfPresent((Object)usernamePassword.getUsername());
        if (currentUserToken != null) {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentUserToken.deadline() > currentTimeMillis + Math.min(this.securityManager.globalSessionTimeout(), 60000L)) {
                return new AccessToken(currentUserToken.accessToken(), currentUserToken.deadline() - currentTimeMillis);
            }
        }
        return null;
    }

    private static <T> T throwResponseException(String error, String errorDescription) {
        ImmutableMap errorMessage = ImmutableMap.of((Object)"error", (Object)error, (Object)"error_description", (Object)errorDescription);
        throw HttpApiUtil.newHttpResponseException(HttpStatus.BAD_REQUEST, Jackson.valueToTree((Object)errorMessage));
    }
}

