/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.authentication;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.util.Functions;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.auth.AuthTokenExtractors;
import com.linecorp.armeria.server.auth.OAuth2Token;
import com.linecorp.centraldogma.server.internal.admin.authentication.CentralDogmaSecurityManager;
import com.linecorp.centraldogma.server.internal.command.Command;
import com.linecorp.centraldogma.server.internal.command.CommandExecutor;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutService
extends AbstractHttpService {
    private static final Logger logger = LoggerFactory.getLogger(LogoutService.class);
    private final CentralDogmaSecurityManager securityManager;
    private final CommandExecutor executor;

    public LogoutService(CentralDogmaSecurityManager securityManager, CommandExecutor executor) {
        this.securityManager = Objects.requireNonNull(securityManager, "securityManager");
        this.executor = Objects.requireNonNull(executor, "executor");
    }

    protected HttpResponse doPost(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        CompletableFuture future = new CompletableFuture();
        ((CompletableFuture)req.aggregate().thenAccept(aMsg -> {
            OAuth2Token token = (OAuth2Token)AuthTokenExtractors.OAUTH2.apply(aMsg.headers());
            if (token == null) {
                future.complete(HttpResponse.of((HttpStatus)HttpStatus.OK));
                return;
            }
            ctx.blockingTaskExecutor().execute(() -> {
                String sessionId = token.accessToken();
                ThreadContext.bind((SecurityManager)this.securityManager);
                try {
                    if (this.securityManager.sessionExists(sessionId)) {
                        Subject currentUser = new Subject.Builder((SecurityManager)this.securityManager).sessionCreationEnabled(false).sessionId((Serializable)((Object)sessionId)).buildSubject();
                        Object principal = currentUser.getPrincipal();
                        currentUser.logout();
                        this.executor.execute(Command.removeSession(sessionId)).join();
                        logger.info("{} Logged out: {} ({})", new Object[]{ctx, principal, sessionId});
                    } else {
                        logger.debug("{} Tried to log out a non-existent session: {}", (Object)ctx, (Object)sessionId);
                    }
                    future.complete(HttpResponse.of((HttpStatus)HttpStatus.OK));
                }
                catch (Throwable t) {
                    logger.warn("{} Failed to log out: {}", new Object[]{ctx, sessionId, t});
                    future.complete(HttpResponse.of((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR));
                }
                finally {
                    ThreadContext.unbindSecurityManager();
                }
            });
        })).exceptionally(Functions.voidFunction(cause -> {
            logger.warn("{} Unexpected exception:", (Object)ctx, cause);
            future.complete(HttpResponse.of((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR));
        }));
        return HttpResponse.from(future);
    }
}

