/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.authentication;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.auth.AuthTokenExtractors;
import com.linecorp.armeria.server.auth.Authorizer;
import com.linecorp.armeria.server.auth.OAuth2Token;
import com.linecorp.centraldogma.server.internal.admin.authentication.AuthenticationUtil;
import com.linecorp.centraldogma.server.internal.admin.authentication.CentralDogmaSecurityManager;
import com.linecorp.centraldogma.server.internal.admin.authentication.User;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTokenAuthorizer
implements Authorizer<HttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger(SessionTokenAuthorizer.class);
    private final CentralDogmaSecurityManager securityManager;
    private final Set<String> administrators;

    public SessionTokenAuthorizer(CentralDogmaSecurityManager securityManager, Set<String> administrators) {
        this.securityManager = Objects.requireNonNull(securityManager, "securityManager");
        this.administrators = Objects.requireNonNull(administrators, "administrators");
    }

    public CompletionStage<Boolean> authorize(ServiceRequestContext ctx, HttpRequest data) {
        OAuth2Token token = (OAuth2Token)AuthTokenExtractors.OAUTH2.apply(data.headers());
        if (token == null) {
            return CompletableFuture.completedFuture(false);
        }
        CompletableFuture<Boolean> res = new CompletableFuture<Boolean>();
        ctx.blockingTaskExecutor().execute(() -> {
            String sessionId = token.accessToken();
            boolean isAuthenticated = false;
            try {
                String p;
                Object principal;
                if (!this.securityManager.sessionExists(sessionId)) {
                    SessionTokenAuthorizer.logNonExistentSession(sessionId);
                    return;
                }
                Subject currentUser = new Subject.Builder((SecurityManager)this.securityManager).sessionCreationEnabled(false).sessionId((Serializable)((Object)sessionId)).buildSubject();
                Object object = principal = currentUser != null ? currentUser.getPrincipal() : null;
                if (principal == null) {
                    SessionTokenAuthorizer.logNonExistentSession(sessionId);
                    return;
                }
                User user = new User(p, this.administrators.contains(p = principal.toString()) ? User.LEVEL_ADMIN : User.LEVEL_USER);
                AuthenticationUtil.setCurrentUser(ctx, user);
                isAuthenticated = true;
            }
            catch (Throwable t) {
                logger.warn("Failed to authorize a session: {}", (Object)sessionId, (Object)t);
            }
            finally {
                res.complete(isAuthenticated);
            }
        });
        return res;
    }

    private static void logNonExistentSession(String sessionId) {
        logger.debug("Non-existent session: {}", (Object)sessionId);
    }
}

