/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.service;

import com.google.common.collect.ImmutableList;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.command.Command;
import com.linecorp.centraldogma.server.internal.storage.project.Project;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

final class RepositoryUtil {
    static CompletableFuture<?> push(AbstractService service, String projectName, String repositoryName, Revision revision, Author author, String commitSummary, String commitDetail, Markup commitMarkup, Change<?> change) {
        return ((Repository)((Project)service.projectManager().get(projectName)).repos().get(repositoryName)).normalize(revision).thenCompose(normalizedRevision -> RepositoryUtil.push0(service, projectName, repositoryName, revision, author, commitSummary, commitDetail, commitMarkup, change));
    }

    private static CompletableFuture<?> push0(AbstractService service, String projectName, String repositoryName, Revision normalizedRev, Author author, String commitSummary, String commitDetail, Markup commitMarkup, Change<?> change) {
        CompletableFuture<Map<String, Change<?>>> f = RepositoryUtil.normalizeChanges(service.projectManager(), projectName, repositoryName, normalizedRev, ImmutableList.of(change));
        return f.thenCompose(changes -> service.execute(Command.push(author, projectName, repositoryName, normalizedRev, commitSummary, commitDetail, commitMarkup, changes.values())));
    }

    private static CompletableFuture<Map<String, Change<?>>> normalizeChanges(ProjectManager projectManager, String projectName, String repositoryName, Revision baseRevision, Iterable<Change<?>> changes) {
        return ((Repository)((Project)projectManager.get(projectName)).repos().get(repositoryName)).previewDiff(baseRevision, changes);
    }

    private RepositoryUtil() {
    }
}

