/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.Functions;
import com.linecorp.armeria.server.annotation.Decorator;
import com.linecorp.armeria.server.annotation.Default;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.RequestConverter;
import com.linecorp.armeria.server.annotation.RequestObject;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.ChangeType;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.RedundantChangeException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.RevisionRange;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.api.v1.CommitMessageDto;
import com.linecorp.centraldogma.internal.api.v1.EntryDto;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.DtoConverter;
import com.linecorp.centraldogma.server.internal.api.HttpApiExceptionHandler;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.api.WatchService;
import com.linecorp.centraldogma.server.internal.api.auth.HasReadPermission;
import com.linecorp.centraldogma.server.internal.api.auth.HasWritePermission;
import com.linecorp.centraldogma.server.internal.api.converter.ChangesRequestConverter;
import com.linecorp.centraldogma.server.internal.api.converter.CommitMessageRequestConverter;
import com.linecorp.centraldogma.server.internal.api.converter.QueryRequestConverter;
import com.linecorp.centraldogma.server.internal.api.converter.WatchRequestConverter;
import com.linecorp.centraldogma.server.internal.command.Command;
import com.linecorp.centraldogma.server.internal.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.internal.storage.repository.FindOption;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

@RequestConverter(value=CommitMessageRequestConverter.class)
@ExceptionHandler(value=HttpApiExceptionHandler.class)
public class ContentServiceV1
extends AbstractService {
    private static final Map<FindOption<?>, ?> FIND_WITHOUT_CONTENT = ImmutableMap.of(FindOption.FETCH_CONTENT, (Object)false);
    private final WatchService watchService;

    public ContentServiceV1(ProjectManager projectManager, CommandExecutor executor, WatchService watchService) {
        super(projectManager, executor);
        this.watchService = Objects.requireNonNull(watchService, "watchService");
    }

    @Get(value="regex:/projects/(?<projectName>[^/]+)/repos/(?<repoName>[^/]+)/list(?<path>(|/.*))$")
    @Decorator(value=HasReadPermission.class)
    public CompletableFuture<List<EntryDto<?>>> listFiles(@Param(value="path") String path, @Param(value="revision") @Default(value="-1") String revision, @RequestObject Repository repository) {
        String normalizedPath = ContentServiceV1.normalizePath(path);
        CompletableFuture future = new CompletableFuture();
        ContentServiceV1.listFiles(repository, normalizedPath, repository.normalizeNow(new Revision(revision)), FIND_WITHOUT_CONTENT, future);
        return future;
    }

    private static void listFiles(Repository repository, String pathPattern, Revision normalizedRevision, Map<FindOption<?>, ?> options, CompletableFuture<List<EntryDto<?>>> result) {
        repository.find(normalizedRevision, pathPattern, options).handle(Functions.voidFunction((entries, thrown) -> {
            if (thrown != null) {
                result.completeExceptionally((Throwable)thrown);
                return;
            }
            if (Util.isValidFilePath((String)pathPattern) && entries.size() == 1 && ((Entry)entries.values().iterator().next()).type() == EntryType.DIRECTORY) {
                ContentServiceV1.listFiles(repository, pathPattern + "/*", normalizedRevision, options, result);
            } else {
                result.complete((List<EntryDto<?>>)entries.values().stream().map(entry -> DtoConverter.convert(repository, entry)).collect(ImmutableList.toImmutableList()));
            }
        }));
    }

    private static String normalizePath(String path) {
        if (path == null || "".equals(path) || "/".equals(path)) {
            return "/*";
        }
        if (Util.isValidFilePath((String)path)) {
            return path;
        }
        if (Util.isValidDirPath((String)path)) {
            if (path.endsWith("/")) {
                return path + "*";
            }
            return path + "/*";
        }
        return path;
    }

    @Post(value="/projects/{projectName}/repos/{repoName}/contents")
    @Decorator(value=HasWritePermission.class)
    public CompletableFuture<?> commit(@Param(value="revision") @Default(value="-1") String revision, @RequestObject Repository repository, @RequestObject Author author, @RequestObject CommitMessageDto commitMessage, @RequestObject(value=ChangesRequestConverter.class) Iterable<Change<?>> changes) {
        Revision normalizedRevision = repository.normalizeNow(new Revision(revision));
        CompletableFuture<Map<String, Change<?>>> changesFuture = repository.previewDiff(normalizedRevision, changes);
        return changesFuture.thenCompose(previewDiffs -> {
            long commitTimeMillis = System.currentTimeMillis();
            if (previewDiffs.isEmpty()) {
                throw new RedundantChangeException();
            }
            CompletableFuture<Revision> resultRevisionFuture = this.push(commitTimeMillis, author, repository, normalizedRevision, commitMessage, previewDiffs.values()).toCompletableFuture();
            String pathPattern = ContentServiceV1.joinPaths(changes);
            CompletionStage findFuture = resultRevisionFuture.thenCompose(result -> repository.find((Revision)result, pathPattern, FIND_WITHOUT_CONTENT));
            return ((CompletableFuture)findFuture).thenApply(entries -> {
                Revision resultRevision = (Revision)resultRevisionFuture.join();
                ImmutableList<EntryDto<?>> entryDtos = ContentServiceV1.entryDtos(repository, entries);
                return DtoConverter.convert(resultRevision, author, commitMessage, commitTimeMillis, entryDtos);
            });
        });
    }

    private CompletableFuture<Revision> push(long commitTimeMills, Author author, Repository repository, Revision revision, CommitMessageDto commitMessage, Iterable<Change<?>> changes) {
        String summary = commitMessage.summary();
        String detail = commitMessage.detail();
        Markup markup = commitMessage.markup();
        return this.execute(Command.push((Long)commitTimeMills, author, repository.parent().name(), repository.name(), revision, summary, detail, markup, changes));
    }

    private static String joinPaths(Iterable<Change<?>> changes) {
        StringBuilder sb = new StringBuilder();
        for (Change<?> c : changes) {
            if (c.type() == ChangeType.RENAME) {
                sb.append(c.contentAsText());
            } else {
                sb.append(c.path());
            }
            sb.append(',');
        }
        return sb.toString();
    }

    private static ImmutableList<EntryDto<?>> entryDtos(Repository repository, Map<String, Entry<?>> entries) {
        return (ImmutableList)entries.values().stream().map(entry -> DtoConverter.convert(repository, entry.path(), entry.type())).collect(ImmutableList.toImmutableList());
    }

    @Get(value="regex:/projects/(?<projectName>[^/]+)/repos/(?<repoName>[^/]+)/contents(?<path>(|/.*))$")
    @Decorator(value=HasReadPermission.class)
    public CompletableFuture<?> getFiles(@Param(value="path") String path, @Param(value="revision") @Default(value="-1") String revision, @RequestObject Repository repository, @RequestObject(value=WatchRequestConverter.class) Optional<WatchRequestConverter.WatchRequest> watchRequest, @RequestObject(value=QueryRequestConverter.class) Optional<Query<?>> query) {
        String normalizedPath = ContentServiceV1.normalizePath(path);
        if (watchRequest.isPresent()) {
            Revision lastKnownRevision = watchRequest.get().lastKnownRevision();
            long timeOutMillis = watchRequest.get().timeoutMillis();
            if (query.isPresent()) {
                return this.watchFile(repository, lastKnownRevision, query.get(), timeOutMillis);
            }
            return this.watchRepository(repository, lastKnownRevision, normalizedPath, timeOutMillis);
        }
        if (query.isPresent()) {
            return repository.get(new Revision(revision), query.get()).handle(HttpApiUtil.returnOrThrow(result -> DtoConverter.convert(repository, result)));
        }
        CompletableFuture future = new CompletableFuture();
        ContentServiceV1.listFiles(repository, normalizedPath, repository.normalizeNow(new Revision(revision)), ImmutableMap.of(), future);
        return future;
    }

    private CompletableFuture<?> watchFile(Repository repository, Revision lastKnownRevision, Query<?> query, long timeOutMillis) {
        CompletableFuture<Entry<?>> future = this.watchService.watchFile(repository, lastKnownRevision, query, timeOutMillis);
        return ((CompletableFuture)future.thenCompose(result -> ContentServiceV1.handleWatchSuccess(repository, result.revision(), query.path()))).exceptionally(this::handleWatchFailure);
    }

    private static CompletableFuture<Object> handleWatchSuccess(Repository repository, Revision revision, String pathPattern) {
        CompletableFuture<List<Commit>> historyFuture = repository.history(revision, revision, pathPattern);
        return repository.find(revision, pathPattern, FIND_WITHOUT_CONTENT).thenCombine(historyFuture, (entryMap, commits) -> {
            ImmutableList<EntryDto<?>> entryDtos = ContentServiceV1.entryDtos(repository, entryMap);
            return DtoConverter.convert((Commit)commits.get(0), entryDtos);
        });
    }

    private Object handleWatchFailure(Throwable thrown) {
        if (Throwables.getRootCause((Throwable)thrown) instanceof CancellationException && !this.watchService.isServerStopping()) {
            return HttpResponse.of((HttpStatus)HttpStatus.NOT_MODIFIED);
        }
        return Exceptions.throwUnsafely((Throwable)thrown);
    }

    private CompletableFuture<?> watchRepository(Repository repository, Revision lastKnownRevision, String pathPattern, long timeOutMillis) {
        CompletableFuture<Revision> future = this.watchService.watchRepository(repository, lastKnownRevision, pathPattern, timeOutMillis);
        return ((CompletableFuture)future.thenCompose(revision -> ContentServiceV1.handleWatchSuccess(repository, revision, pathPattern))).exceptionally(this::handleWatchFailure);
    }

    @Get(value="regex:/projects/(?<projectName>[^/]+)/repos/(?<repoName>[^/]+)/commits(?<revision>(|/.*))$")
    @Decorator(value=HasReadPermission.class)
    public CompletableFuture<?> listCommits(@Param(value="revision") String revision, @Param(value="path") @Default(value="/**") String path, @Param(value="to") Optional<String> to, @RequestObject Repository repository) {
        Revision toRevision;
        Revision fromRevision;
        if (Strings.isNullOrEmpty((String)revision) || "/".equalsIgnoreCase(revision)) {
            fromRevision = Revision.HEAD;
            toRevision = to.map(Revision::new).orElse(Revision.INIT);
        } else {
            fromRevision = new Revision(revision.substring(1));
            toRevision = to.map(Revision::new).orElse(fromRevision);
        }
        RevisionRange range = repository.normalizeNow(fromRevision, toRevision).toDescending();
        return repository.history(range.from(), range.to(), path).thenApply(commits -> {
            boolean toList = Strings.isNullOrEmpty((String)revision) || "/".equalsIgnoreCase(revision) || to.isPresent();
            return ContentServiceV1.objectOrList(commits, toList, DtoConverter::convert);
        });
    }

    @Get(value="/projects/{projectName}/repos/{repoName}/compare")
    @Decorator(value=HasReadPermission.class)
    public CompletableFuture<?> getDiff(@Param(value="path") @Default(value="/**") String pathPattern, @Param(value="from") @Default(value="1") String from, @Param(value="to") @Default(value="head") String to, @RequestObject Repository repository, @RequestObject(value=QueryRequestConverter.class) Optional<Query<?>> query) {
        if (query.isPresent()) {
            return repository.diff(new Revision(from), new Revision(to), query.get()).thenApply(DtoConverter::convert);
        }
        return repository.diff(new Revision(from), new Revision(to), pathPattern).thenApply(changeMap -> (ImmutableList)changeMap.values().stream().map(DtoConverter::convert).collect(ImmutableList.toImmutableList()));
    }

    private static <T> Object objectOrList(Collection<T> collection, boolean toList, Function<T, ?> converter) {
        if (collection.isEmpty()) {
            return ImmutableList.of();
        }
        if (toList) {
            return collection.stream().map(converter).collect(ImmutableList.toImmutableList());
        }
        return converter.apply(Iterables.getOnlyElement(collection));
    }
}

