/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.google.common.collect.ImmutableMap;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import com.linecorp.centraldogma.common.ChangeConflictException;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.ProjectExistsException;
import com.linecorp.centraldogma.common.ProjectNotFoundException;
import com.linecorp.centraldogma.common.RedundantChangeException;
import com.linecorp.centraldogma.common.RepositoryExistsException;
import com.linecorp.centraldogma.common.RepositoryNotFoundException;
import com.linecorp.centraldogma.common.RevisionNotFoundException;
import com.linecorp.centraldogma.server.internal.admin.service.TokenNotFoundException;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryMetadataException;
import java.util.Map;

public final class HttpApiExceptionHandler
implements ExceptionHandlerFunction {
    private final Map<Class<?>, ExceptionHandlerFunction> exceptionHandlers = ImmutableMap.builder().put(ChangeConflictException.class, HttpApiExceptionHandler::handleConflict).put(EntryNotFoundException.class, HttpApiExceptionHandler::handleNotFound).put(ProjectExistsException.class, HttpApiExceptionHandler::handleExists).put(ProjectNotFoundException.class, HttpApiExceptionHandler::handleNotFound).put(RedundantChangeException.class, HttpApiExceptionHandler::handleRedundantChange).put(RepositoryExistsException.class, HttpApiExceptionHandler::handleExists).put(RepositoryMetadataException.class, HttpApiExceptionHandler::fallthrough).put(RepositoryNotFoundException.class, HttpApiExceptionHandler::handleNotFound).put(RevisionNotFoundException.class, HttpApiExceptionHandler::handleNotFound).put(TokenNotFoundException.class, HttpApiExceptionHandler::handleNotFound).build();

    public HttpResponse handleException(RequestContext ctx, HttpRequest req, Throwable cause) {
        if (cause instanceof IllegalArgumentException) {
            if (cause.getMessage() != null) {
                return HttpApiUtil.newResponseWithErrorMessage(HttpStatus.BAD_REQUEST, cause.getMessage());
            }
            return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST);
        }
        ExceptionHandlerFunction func = this.exceptionHandlers.get(cause.getClass());
        if (func != null) {
            return func.handleException(ctx, req, cause);
        }
        return (HttpResponse)ExceptionHandlerFunction.fallthrough();
    }

    static HttpResponse handleExists(RequestContext ctx, HttpRequest req, Throwable cause) {
        return HttpApiUtil.newResponseWithErrorMessage(HttpStatus.CONFLICT, cause.getMessage() + " already exists.");
    }

    static HttpResponse handleNotFound(RequestContext ctx, HttpRequest req, Throwable cause) {
        return HttpApiUtil.newResponseWithErrorMessage(HttpStatus.NOT_FOUND, cause.getMessage() + " does not exist.");
    }

    static HttpResponse handleRedundantChange(RequestContext ctx, HttpRequest req, Throwable cause) {
        return HttpApiUtil.newResponseWithErrorMessage(HttpStatus.BAD_REQUEST, "changes did not change anything.");
    }

    static HttpResponse handleConflict(RequestContext ctx, HttpRequest req, Throwable cause) {
        return HttpResponse.of((HttpStatus)HttpStatus.CONFLICT);
    }

    static HttpResponse fallthrough(RequestContext ctx, HttpRequest req, Throwable cause) {
        return (HttpResponse)ExceptionHandlerFunction.fallthrough();
    }
}

