/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.command;

import com.google.common.collect.ImmutableList;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.ProjectExistsException;
import com.linecorp.centraldogma.common.RepositoryExistsException;
import com.linecorp.centraldogma.server.internal.command.Command;
import com.linecorp.centraldogma.server.internal.command.CommandExecutor;

public final class ProjectInitializer {
    public static final String INTERNAL_PROJECT_NAME = "dogma";
    public static final String INTERNAL_REPOSITORY_NAME = "main";

    public static void initializeInternalProject(CommandExecutor executor) {
        block5: {
            try {
                executor.execute(Command.createProject(Author.SYSTEM, INTERNAL_PROJECT_NAME)).get();
            }
            catch (Throwable cause) {
                cause = Exceptions.peel((Throwable)cause);
                if (cause instanceof ProjectExistsException) break block5;
                throw new Error("failed to initialize an internal project", cause);
            }
        }
        for (String repo : ImmutableList.of((Object)"meta", (Object)INTERNAL_REPOSITORY_NAME)) {
            try {
                executor.execute(Command.createRepository(Author.SYSTEM, INTERNAL_PROJECT_NAME, repo)).get();
            }
            catch (Throwable cause) {
                cause = Exceptions.peel((Throwable)cause);
                if (cause instanceof RepositoryExistsException) continue;
                throw new Error(cause);
            }
        }
    }

    private ProjectInitializer() {
    }
}

