/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.command;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.server.internal.command.Command;
import com.linecorp.centraldogma.server.internal.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.command.CreateProjectCommand;
import com.linecorp.centraldogma.server.internal.command.ForwardingCommandExecutor;
import com.linecorp.centraldogma.server.internal.metadata.Member;
import com.linecorp.centraldogma.server.internal.metadata.ProjectMetadata;
import com.linecorp.centraldogma.server.internal.metadata.ProjectRole;
import com.linecorp.centraldogma.server.internal.metadata.RepositoryMetadata;
import com.linecorp.centraldogma.server.internal.metadata.TokenRegistration;
import com.linecorp.centraldogma.server.internal.metadata.UserAndTimestamp;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectInitializingCommandExecutor
extends ForwardingCommandExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ProjectInitializingCommandExecutor.class);

    public ProjectInitializingCommandExecutor(CommandExecutor delegate) {
        super(delegate);
    }

    @Override
    public <T> CompletableFuture<T> execute(Command<T> command) {
        if (!(command instanceof CreateProjectCommand)) {
            return super.execute(command);
        }
        CreateProjectCommand c = (CreateProjectCommand)command;
        String projectName = c.projectName();
        long creationTimeMillis = c.timestamp();
        Author author = c.author();
        CompletableFuture<Void> f = this.delegate().execute(c);
        return ((CompletableFuture)((CompletableFuture)f.thenCompose(unused -> this.delegate().execute(Command.createRepository(creationTimeMillis, author, projectName, "meta")))).thenCompose(unused -> ProjectInitializingCommandExecutor.initializeMetadata(this.delegate(), projectName, author))).thenApply(unused -> null);
    }

    private static CompletableFuture<Revision> initializeMetadata(CommandExecutor executor, String projectName, Author author) {
        if (projectName.equals("dogma")) {
            return CompletableFuture.completedFuture(Revision.INIT);
        }
        logger.info("Initializing metadata: {}", (Object)projectName);
        UserAndTimestamp userAndTimestamp = UserAndTimestamp.of(author);
        Member member = new Member(author, ProjectRole.OWNER, userAndTimestamp);
        ProjectMetadata metadata = new ProjectMetadata(projectName, (Map<String, RepositoryMetadata>)ImmutableMap.of(), (Map<String, Member>)ImmutableMap.of((Object)member.id(), (Object)member), (Map<String, TokenRegistration>)ImmutableMap.of(), userAndTimestamp, null);
        return executor.execute(Command.push(Author.SYSTEM, projectName, "meta", Revision.HEAD, "Initialize metadata", "", Markup.PLAINTEXT, Change.ofJsonUpsert((String)"/metadata.json", (JsonNode)Jackson.valueToTree((Object)metadata))));
    }
}

