/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.command;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.server.internal.command.CommandType;
import com.linecorp.centraldogma.server.internal.command.ProjectCommand;
import java.util.Objects;
import javax.annotation.Nullable;

public final class SaveNamedQueryCommand
extends ProjectCommand<Void> {
    private final String queryName;
    private final boolean enabled;
    private final String repositoryName;
    private final Query<?> query;
    private final String comment;
    private final Markup markup;

    @JsonCreator
    SaveNamedQueryCommand(@JsonProperty(value="timestamp") @Nullable Long timestamp, @JsonProperty(value="author") @Nullable Author author, @JsonProperty(value="projectName") String projectName, @JsonProperty(value="queryName") String queryName, @JsonProperty(value="enabled") boolean enabled, @JsonProperty(value="repositoryName") String repositoryName, @JsonProperty(value="query") Query<?> query, @JsonProperty(value="comment") String comment, @JsonProperty(value="markup") Markup markup) {
        super(CommandType.SAVE_NAMED_QUERY, timestamp, author, projectName);
        this.queryName = Objects.requireNonNull(queryName, "queryName");
        this.enabled = enabled;
        this.repositoryName = Objects.requireNonNull(repositoryName, "repositoryName");
        this.query = Objects.requireNonNull(query, "query");
        this.comment = Objects.requireNonNull(comment, "comment");
        this.markup = Objects.requireNonNull(markup, "markup");
    }

    @JsonProperty
    public String queryName() {
        return this.queryName;
    }

    @JsonProperty
    public boolean isEnabled() {
        return this.enabled;
    }

    @JsonProperty
    public String repositoryName() {
        return this.repositoryName;
    }

    @JsonProperty
    public <T> Query<T> query() {
        return this.query;
    }

    @JsonProperty
    public String comment() {
        return this.comment;
    }

    @JsonProperty
    public Markup markup() {
        return this.markup;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SaveNamedQueryCommand)) {
            return false;
        }
        SaveNamedQueryCommand that = (SaveNamedQueryCommand)obj;
        return super.equals(obj) && this.queryName.equals(that.queryName) && this.enabled == that.enabled && this.repositoryName.equals(that.repositoryName) && this.query.equals(that.query) && this.comment.equals(that.comment) && this.markup == that.markup;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.queryName, this.enabled, this.repositoryName, this.query, this.comment, this.markup) * 31 + super.hashCode();
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("queryName", (Object)this.queryName).add("enabled", this.enabled).add("repositoryName", (Object)this.repositoryName).add("query", this.query).add("comment", (Object)this.comment).add("markup", (Object)this.markup);
    }
}

